/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.web.controller;

import com.alibaba.fastjson.JSON;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.vo.EmailCodeInfo;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.mail.MailMessageCommand;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.utils.SmtpSendUtils;
import com.els.base.utils.encryption.DESUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6d88\u606f\u7ba1\u7406-\u90ae\u7bb1-\u9a8c\u8bc1\u7801")
@Controller
@RequestMapping(value={"mailVerificationCode"})
public class MailVerfiCodeController {
    private static final Logger logger = LoggerFactory.getLogger(MailVerfiCodeController.class);
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @Resource
    UserService userService;
    @Resource
    protected MailAccountService mailAccountService;

    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"/front/sendCode"})
    @ResponseBody
    public ResponseResult<String> sendCode(HttpSession session, String receiveEmailAddress, String receiveName) throws Exception {
        Assert.isNotBlank((String)receiveEmailAddress, (String)"\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        MailAccount mailAccount = this.mailAccountService.queryDefaultMailAccoutByCompanyId(ProjectUtils.getProject().getCompanyId());
        Assert.isNotNull((Object)mailAccount, (String)"\u90ae\u7bb1\u670d\u52a1\u5668\u8fd8\u6ca1\u6709\u914d\u7f6e");
        int code = RandomUtils.nextInt((int)1000, (int)9999);
        session.setAttribute("mailVerifCode", (Object)String.valueOf(code));
        session.setAttribute("mailVerifAddress", (Object)receiveEmailAddress);
        logger.debug("{}\u7684\u90ae\u7bb1\u9a8c\u8bc1\u7801\u662f\uff1a{}", (Object)receiveEmailAddress, (Object)code);
        String mailContent = MessageFormat.format("\u60a8\u7684\u90ae\u7bb1\u9a8c\u8bc1\u7801\u662f\uff1a{0}", String.valueOf(code));
        SmtpSendUtils.sendMail(mailAccount, receiveEmailAddress, receiveName, "\u90ae\u7bb1\u9a8c\u8bc1\u7801", mailContent);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u53d1\u9001\u627e\u56de\u5bc6\u7801\u90ae\u7bb1\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"/front/sendRetrievePasswordVerifyCode"})
    @ResponseBody
    public ResponseResult<String> sendRetrievePasswordVerifyCode(String email, String returnUrl) throws Exception {
        Assert.isNotBlank((String)email, (String)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)returnUrl, (String)"\u8fd4\u56de\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        User receiver = (User)this.userService.queryByEmail(email).orElseThrow(() -> new CommonException("\u8be5\u90ae\u7bb1\u672a\u7ed1\u5b9a\u8d26\u53f7"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userNickName", receiver.getNickName());
        data.put("operationTime", DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_PATTERN));
        data.put("validationUrl", this.resolveReturnUrl(receiver.getId(), returnUrl));
        Message message = new Message(null, null, receiver.getId(), "SEND_RETRIEVE_PASSWORD_MSG", MessageLevelEnum.MIDDLE, data);
        new MailMessageCommand().sendMsg(message);
        return ResponseResult.success();
    }

    private String resolveReturnUrl(String userId, String returnUrl) throws Exception {
        EmailCodeInfo codeInfo = new EmailCodeInfo();
        codeInfo.setUserId(userId);
        codeInfo.setExpiryDate(LocalDateTime.now().plusDays(2L));
        String code = DESUtils.encrypt((String)JSON.toJSONString((Object)codeInfo));
        return returnUrl + "?code=" + code;
    }
}

