/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail;

import com.els.base.core.entity.user.User;
import com.els.base.core.service.user.UserService;
import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailTemplate;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.service.MailTemplateService;
import com.els.base.msg.mail.utils.SmtpSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailMessageCommand
implements IMessageCommand {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(MailMessageCommand.class);

    protected static MailAccountService getMailAccountService() {
        return (MailAccountService)SpringContextHolder.getOneBean(MailAccountService.class);
    }

    protected static MailTemplateService getMailTemplateService() {
        return (MailTemplateService)SpringContextHolder.getOneBean(MailTemplateService.class);
    }

    protected static UserService getUserService() {
        return (UserService)SpringContextHolder.getOneBean(UserService.class);
    }

    @Override
    public void sendMsg(IMessage<?> message) throws Exception {
        MailAccount sendMailAccount = this.getSenderMailAccountByUserId(message);
        if (sendMailAccount == null) {
            logger.warn("\u53d1\u9001\u8005\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6");
            return;
        }
        List<String> receiverIdList = message.getReceiverIdList();
        if (CollectionUtils.isEmpty(receiverIdList)) {
            logger.warn("\u63a5\u6536\u4eba\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6");
            return;
        }
        String typeCode = message.getBusinessTypeCode();
        MailTemplate mailTemplate = MailMessageCommand.getMailTemplateService().queryMailTemplateByBusinessType(typeCode);
        if (mailTemplate == null) {
            logger.warn("\u90ae\u7bb1\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u51fa\u90ae\u4ef6");
            return;
        }
        for (String receiveId : receiverIdList) {
            MailAccount receiverMailAccount = this.getReceiverMailAccountByUserId(receiveId);
            if (receiverMailAccount == null) {
                logger.warn("\u63a5\u6536\u4eba\u7684\u90ae\u7bb1\u4fe1\u606f\u4e3a\u7a7a\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6");
                continue;
            }
            try {
                this.sendMsg(receiverMailAccount, sendMailAccount, message.getData(), mailTemplate);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private MailAccount getSenderMailAccountByUserId(IMessage<?> message) {
        MailAccount sendMailAccount = null;
        if ("systemDefaultSender".equals(message.getSenderId())) {
            return MailMessageCommand.getMailAccountService().querySystemDefaultMailAccout();
        }
        if (StringUtils.isNotBlank((String)message.getSenderId())) {
            sendMailAccount = MailMessageCommand.getMailAccountService().queryByUserId(message.getSenderId());
        }
        if (sendMailAccount != null) {
            return sendMailAccount;
        }
        sendMailAccount = MailMessageCommand.getMailAccountService().querySystemDefaultMailAccout();
        return sendMailAccount;
    }

    private MailAccount getReceiverMailAccountByUserId(String receiveId) {
        if (StringUtils.isBlank((String)receiveId)) {
            return null;
        }
        MailAccount receiverMailAccount = MailMessageCommand.getMailAccountService().queryByUserId(receiveId);
        if (receiverMailAccount != null) {
            return receiverMailAccount;
        }
        User user = (User)MailMessageCommand.getUserService().queryObjById((Object)receiveId);
        if (user != null && StringUtils.isNotBlank((String)user.getEmail())) {
            MailAccount mailAccount = new MailAccount();
            mailAccount.setUserId(receiveId);
            mailAccount.setMailAddress(user.getEmail());
            mailAccount.setUserName(user.getNickName());
            return mailAccount;
        }
        return null;
    }

    protected void sendMsg(MailAccount receiverMailAccount, MailAccount sendMailAccount, Object data, MailTemplate mailTemplate) throws Exception {
        String mailContentHtml = mailTemplate.getTemplateContent();
        try {
            mailContentHtml = BeetlTemplateUtils.renderFromString((String)mailContentHtml, (String)"message", (Object)data);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u90ae\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        String subject = mailTemplate.getTemplateTitle();
        try {
            subject = BeetlTemplateUtils.renderFromString((String)subject, (String)"message", (Object)data);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u90ae\u4ef6\u6807\u9898\u5931\u8d25", (Throwable)e);
        }
        logger.debug("--------\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6------");
        SmtpSendUtils.sendMail(sendMailAccount, receiverMailAccount.getMailAddress(), receiverMailAccount.getUserName(), subject, mailContentHtml);
        logger.debug("--------\u7ed3\u675f\u53d1\u9001\u90ae\u4ef6------");
    }
}

