/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.vo.VerifyCode;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.sms.ShortMessageCommand;
import com.els.base.msg.sms.service.SmsTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6d88\u606f\u7ba1\u7406-\u77ed\u4fe1-\u9a8c\u8bc1\u7801")
@Controller
@RequestMapping(value={"smsVerifyCode"})
public class SmsVerifyCodeController {
    private static final Logger logger = LoggerFactory.getLogger(SmsVerifyCodeController.class);
    private static final String SMS_VERIFY_CODE = "SMS_VERIFY_CODE";
    private static final String SMS_DIC_CONFIG_NAME = "SMS_CONFIG";
    private static final String SMS_INTERVAL = "INTERVAL";
    private static final String SMS_EXPIRE_IN = "EXPIRE_IN";
    private static final String SMS_MAX_TRY_TIMES = "MAX_TRY_TIMES";
    @Resource
    private UserService userService;
    @Resource
    private SmsTemplateService smsTemplateService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private DicGroupItemService dicGroupItemService;

    @ApiOperation(value="\u53d1\u9001\u767b\u5f55\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"/front/sendLoginVerifyCode"})
    @ResponseBody
    public ResponseResult<String> sendLoginVerifyCode(HttpSession session, String mobile) {
        Assert.isNotBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        VerifyCode verifyCode = (VerifyCode)session.getAttribute("login.sms.verify.code");
        if (verifyCode != null) {
            this.validate(verifyCode);
        }
        User user = (User)this.userService.queryByMobilePhone(mobile).orElseThrow(() -> new CommonException("\u624b\u673a\u53f7\u672a\u7ed1\u5b9a\u5e10\u53f7"));
        String code = this.generateCodeService.getNextCode(SMS_VERIFY_CODE);
        verifyCode = this.generateVerifyCode(code, 300, 60, 10);
        session.setAttribute("login.phone", (Object)mobile);
        session.setAttribute("login.sms.verify.code", (Object)verifyCode);
        HashMap<String, Object> msgData = new HashMap<String, Object>();
        msgData.put("verifyCode", code);
        msgData.put("validTime", verifyCode.getValidTime());
        Message message = new Message(null, null, user.getId(), "SEND_LOGIN_VERIFY_CODE", MessageLevelEnum.MIDDLE, msgData);
        try {
            new ShortMessageCommand().sendMsg(message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u767b\u5f55\u77ed\u4fe1\u9a8c\u8bc1\u7801\u51fa\u9519", (Throwable)e);
            session.removeAttribute("login.sms.verify.code");
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u53d1\u9001\u66f4\u6362\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"/service/sendChangeMobileVerifyCode"})
    @ResponseBody
    public ResponseResult<String> sendChangeMobileVerifyCode(HttpSession session, String currentPhone, String currentPwd, String newPhone) {
        User currentUser = SpringSecurityUtils.getLoginUser();
        if (StringUtils.isNotBlank((String)currentUser.getMobilePhone())) {
            Assert.isNotBlank((String)currentPhone, (String)"\u5f53\u524d\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)currentPwd, (String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (!currentPhone.equals(currentUser.getMobilePhone())) {
                throw new CommonException("\u5f53\u524d\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
            }
            if (!this.userService.checkPassword(currentUser.getId(), currentPwd)) {
                throw new CommonException("\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
        }
        Assert.isNotBlank((String)newPhone, (String)"\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        VerifyCode verifyCode = (VerifyCode)session.getAttribute("modify.phone.sms.verify.code");
        if (verifyCode != null) {
            this.validate(verifyCode);
        }
        if (newPhone.equals(currentPhone)) {
            throw new CommonException("\u65b0\u624b\u673a\u53f7\u4e0d\u80fd\u4e0e\u65e7\u624b\u673a\u53f7\u76f8\u540c");
        }
        this.userService.queryByMobilePhone(newPhone).ifPresent(user -> {
            throw new CommonException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5360\u7528");
        });
        String code = this.generateCodeService.getNextCode(SMS_VERIFY_CODE);
        verifyCode = this.generateVerifyCode(code, 300, 60, 10);
        session.setAttribute("modify.phone.new.phone", (Object)newPhone);
        session.setAttribute("modify.phone.sms.verify.code", (Object)verifyCode);
        User tempUser = this.createTempUser(newPhone);
        HashMap<String, Object> msgData = new HashMap<String, Object>();
        msgData.put("verifyCode", code);
        msgData.put("validTime", verifyCode.getValidTime());
        Message message = new Message(null, null, tempUser.getId(), "SEND_CHANGE_MOBILE_VERIFY_CODE", MessageLevelEnum.MIDDLE, msgData);
        try {
            new ShortMessageCommand().sendMsg(message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u4fee\u6539\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u51fa\u9519", (Throwable)e);
            session.removeAttribute("modify.phone.sms.verify.code");
            throw new CommonException(e.getMessage());
        }
        finally {
            this.removeTempUser(tempUser);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u53d1\u9001\u627e\u56de\u5bc6\u7801\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"/front/sendRetrievePasswordVerifyCode"})
    @ResponseBody
    public ResponseResult<String> sendRetrievePasswordVerifyCode(HttpSession session, String mobile) {
        Assert.isNotBlank((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        VerifyCode verifyCode = (VerifyCode)session.getAttribute("forget.password.sms.verify.code");
        if (verifyCode != null) {
            this.validate(verifyCode);
        }
        User user = (User)this.userService.queryByMobilePhone(mobile).orElseThrow(() -> new CommonException("\u5e10\u53f7\u4e0d\u5b58\u5728"));
        String code = this.generateCodeService.getNextCode(SMS_VERIFY_CODE);
        verifyCode = this.generateVerifyCode(code, 300, 60, 10);
        session.setAttribute("forget.password.phone", (Object)mobile);
        session.setAttribute("forget.password.sms.verify.code", (Object)verifyCode);
        HashMap<String, Object> msgData = new HashMap<String, Object>();
        msgData.put("verifyCode", code);
        msgData.put("validTime", verifyCode.getValidTime());
        Message message = new Message(null, null, user.getId(), "SEND_RETRIEVE_PASSWORD_MSG", MessageLevelEnum.MIDDLE, msgData);
        try {
            new ShortMessageCommand().sendMsg(message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u627e\u56de\u5bc6\u7801\u77ed\u4fe1\u9a8c\u8bc1\u7801\u51fa\u9519", (Throwable)e);
            session.removeAttribute("forget.password.sms.verify.code");
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success();
    }

    private void validate(VerifyCode verifyCode) {
        Assert.isTrue((Boolean)verifyCode.fetchable(), (String)"\u8bf7\u52ff\u9891\u7e41\u83b7\u53d6\u9a8c\u8bc1\u7801");
    }

    private VerifyCode generateVerifyCode(String code, Integer defaultExpireIn, Integer defaultInterval, Integer defaultMaxTryTimes) {
        List<DicGroupItem> configList = this.getSmsConfig();
        Integer interval = this.getConfigItem(configList, SMS_INTERVAL, defaultInterval);
        Integer expireIn = this.getConfigItem(configList, SMS_EXPIRE_IN, defaultExpireIn);
        Integer maxTryTimes = this.getConfigItem(configList, SMS_MAX_TRY_TIMES, defaultMaxTryTimes);
        return new VerifyCode(code, expireIn, interval, maxTryTimes);
    }

    private List<DicGroupItem> getSmsConfig() {
        return this.dicGroupItemService.queryItemsByGroupCode(SMS_DIC_CONFIG_NAME);
    }

    private Integer getConfigItem(List<DicGroupItem> configList, String configCode, Integer defaultValue) {
        Integer result = null;
        if (CollectionUtils.isNotEmpty(configList)) {
            for (DicGroupItem config : configList) {
                if (!configCode.equals(config.getCode())) continue;
                if (StringUtils.isBlank((String)config.getValue())) {
                    return null;
                }
                try {
                    result = Integer.valueOf(config.getValue());
                    break;
                }
                catch (Exception e) {
                    logger.error("\u5b57\u5178\u503cSMS_CONFIG.{}\u914d\u7f6e\u9519\u8bef,\u5b57\u5178\u9879\u503c\u5e94\u4e3a\u6570\u5b57", (Object)configCode);
                    throw new CommonException("\u5b57\u5178\u503cSMS_CONFIG." + configCode + "\u914d\u7f6e\u9519\u8bef,\u5b57\u5178\u9879\u503c\u5e94\u4e3a\u6570\u5b57");
                }
            }
        }
        return result == null ? defaultValue : result;
    }

    private User createTempUser(String mobile) {
        String now = Long.toString(System.currentTimeMillis());
        User user = new User();
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        user.setLoginName(now);
        user.setNickName(now);
        user.setPassword(now);
        user.setMobilePhone(mobile);
        this.userService.addObj((Serializable)user);
        return user;
    }

    private void removeTempUser(User user) {
        this.userService.deleteObjById((Object)user.getId());
    }
}

