/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.weixin.web.controller;

import com.els.base.auth.entity.AuthUser;
import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.utils.encryption.DESUtils;
import com.els.base.wechat.login.entity.WxScanResults;
import com.els.base.wechat.login.service.WxScanResultsService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5fae\u4fe1\u626b\u7801\u767b\u5f55")
@Controller(value="wxScanLoginController")
@RequestMapping(value={"wxScanLogin"})
public class WxScanLoginController {
    @Autowired
    private UserService userService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected AuthenticationManager authenticationManager;
    @Autowired
    protected WxScanResultsService wxScanResultsService;
    @Autowired
    private ApplicationContext applicationContext;

    @ApiIgnore
    @RequestMapping(value={"service/wxScanLogin"})
    @ResponseBody
    public ResponseResult<String> loginForWxScan(@RequestParam(required=true) String key, HttpServletRequest request) {
        WxScanResults results = this.wxScanResultsService.queryUserIdByKey(key);
        if (results == null) {
            return null;
        }
        if (results.getUserId() == null) {
            throw new CommonException(String.format("\u767b\u5f55\u5931\u8d25\uff0c\u672a\u5173\u8054\u7528\u6237", new Object[0]));
        }
        User user = (User)this.userService.queryObjById((Object)results.getUserId());
        if (user == null) {
            throw new CommonException(String.format("\u767b\u5f55\u5931\u8d25\uff0c\u5173\u8054\u7528\u6237\u4e0d\u5b58\u5728", new Object[0]));
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getLoginName(), (Object)this.getPassword(user));
        Authentication authResult = this.authenticationManager.authenticate((Authentication)authentication);
        AuthUser userAuthed = (AuthUser)authResult.getPrincipal();
        ArrayList<SimpleGrantedAuthority> roleList = new ArrayList<SimpleGrantedAuthority>();
        for (Role grantedAuthority : this.roleService.queryUserOwnRoles(user.getId())) {
            roleList.add(new SimpleGrantedAuthority(grantedAuthority.getRoleName()));
        }
        userAuthed.setAuthorities(roleList);
        SecurityContextHolder.getContext().setAuthentication(authResult);
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        AuthenticationSuccessEvent event = new AuthenticationSuccessEvent(authResult);
        this.applicationContext.publishEvent((ApplicationEvent)event);
        return ResponseResult.success();
    }

    private String getPassword(User user) {
        Assert.isNotBlank((String)user.getPassword(), (String)"\u5e10\u53f7\u5f02\u5e38");
        String password = null;
        try {
            password = DESUtils.decrypt((String)user.getPassword(), (String)"tissonco");
            if (StringUtils.isNotBlank((String)user.getPasswordKey())) {
                password = password.replace(user.getPasswordKey(), "");
                password = DESUtils.decrypt((String)password, (String)"tissonco");
            }
        }
        catch (Exception e) {
            throw new CommonException("\u5e10\u53f7\u5f02\u5e38", (Throwable)e);
        }
        return password;
    }
}

