/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.websitemsg.dao.WebsiteTemplateMapper;
import com.els.base.websitemsg.entity.WebsiteTemplate;
import com.els.base.websitemsg.entity.WebsiteTemplateExample;
import com.els.base.websitemsg.service.WebsiteTemplateService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultWebsiteTemplateService")
public class WebsiteTemplateServiceImpl
implements WebsiteTemplateService {
    @Resource
    protected WebsiteTemplateMapper websiteTemplateMapper;

    @CacheEvict(value={"websiteTemplate"}, allEntries=true)
    public void addObj(WebsiteTemplate t) {
        this.websiteTemplateMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"websiteTemplate"}, allEntries=true)
    public void addAll(List<WebsiteTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.websiteTemplateMapper.insertBatch(list);
    }

    @CacheEvict(value={"websiteTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.websiteTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"websiteTemplate"}, allEntries=true)
    public void deleteByExample(WebsiteTemplateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.websiteTemplateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"websiteTemplate"}, allEntries=true)
    public void modifyObj(WebsiteTemplate t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.websiteTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"websiteTemplate"}, keyGenerator="redisKeyGenerator")
    public WebsiteTemplate queryObjById(String id) {
        return this.websiteTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"websiteTemplate"}, keyGenerator="redisKeyGenerator")
    public List<WebsiteTemplate> queryAllObjByExample(WebsiteTemplateExample example) {
        return this.websiteTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"websiteTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<WebsiteTemplate> queryObjByPage(WebsiteTemplateExample example) {
        PageView<WebsiteTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.websiteTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<WebsiteTemplate> queryWebsiteTemplateByBusinessType(String typeCode) {
        WebsiteTemplateExample example = new WebsiteTemplateExample();
        example.createCriteria().andBusinessTypeEqualTo(typeCode);
        return this.websiteTemplateMapper.selectByExample(example);
    }
}

