/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.websitemsg.entity.WebsiteTemplate;
import com.els.base.websitemsg.entity.WebsiteTemplateExample;
import com.els.base.websitemsg.service.WebsiteTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f"})
@Controller
@RequestMapping(value={"websiteTemplate"})
public class WebsiteTemplateController {
    @Resource
    protected WebsiteTemplateService websiteTemplateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WebsiteTemplate websiteTemplate) {
        websiteTemplate.setCreateDate(new Date());
        websiteTemplate.setCreateUser(SpringSecurityUtils.getLoginUserName());
        websiteTemplate.setModifyDate(new Date());
        this.websiteTemplateService.addObj(websiteTemplate);
        return ResponseResult.success((Object)websiteTemplate.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WebsiteTemplate websiteTemplate) {
        Assert.isNotBlank((String)websiteTemplate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        websiteTemplate.setModifyDate(new Date());
        this.websiteTemplateService.modifyObj(websiteTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        WebsiteTemplateExample example = new WebsiteTemplateExample();
        example.createCriteria().andIdIn((List)ids);
        this.websiteTemplateService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 WebsiteTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WebsiteTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        WebsiteTemplateExample example = new WebsiteTemplateExample();
        example.setPageView((PageView<WebsiteTemplate>)new PageView(pageNo, pageSize));
        WebsiteTemplateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.websiteTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

