/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.mail.entity.MailTemplate;
import com.els.base.msg.mail.entity.MailTemplateExample;
import com.els.base.msg.mail.service.MailTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6d88\u606f\u7ba1\u7406-\u90ae\u4ef6-\u6a21\u677f\u4fe1\u606f")
@Controller
@RequestMapping(value={"mailTemplate"})
public class MailTemplateController {
    @Resource
    protected MailTemplateService mailTemplateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u90ae\u4ef6\u6a21\u677f\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MailTemplate mailTemplate) {
        if (mailTemplate.getTemplateNum() != null && mailTemplate.getTemplateNum().length() > 255 || mailTemplate.getTemplateTitle() != null && mailTemplate.getTemplateTitle().length() > 255 || mailTemplate.getTemplateName() != null && mailTemplate.getTemplateName().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (!mailTemplate.getBusinessType().matches("[\\w\\_]+")) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
        }
        String projectId = ProjectUtils.getProjectId();
        MailTemplateExample mailTemplateExample = new MailTemplateExample();
        mailTemplateExample.createCriteria().andProjectIdEqualTo(projectId).andBusinessTypeEqualTo(mailTemplate.getBusinessType());
        List mailTemplateList = this.mailTemplateService.queryAllObjByExample((IExample)mailTemplateExample);
        if (CollectionUtils.isNotEmpty((Collection)mailTemplateList)) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", "base_is_exists", new Object[]{"\u4e1a\u52a1\u7c7b\u578b"});
        }
        mailTemplateExample.clear();
        mailTemplateExample.createCriteria().andProjectIdEqualTo(projectId).andTemplateNumEqualTo(mailTemplate.getTemplateNum());
        List queryAllObjByExample = this.mailTemplateService.queryAllObjByExample((IExample)mailTemplateExample);
        if (CollectionUtils.isNotEmpty((Collection)queryAllObjByExample)) {
            throw new CommonException("\u90ae\u4ef6\u6a21\u677f\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", "base_is_exists", new Object[]{"\u90ae\u4ef6\u6a21\u677f\u53f7"});
        }
        mailTemplate.setProjectId(projectId);
        mailTemplate.setCreateUser(SpringSecurityUtils.getLoginUser().getNickName());
        this.mailTemplateService.addObj(mailTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u90ae\u4ef6\u6a21\u677f\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MailTemplate mailTemplate) {
        if (StringUtils.isBlank((String)mailTemplate.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (mailTemplate.getTemplateNum() != null && mailTemplate.getTemplateNum().length() > 255 || mailTemplate.getTemplateTitle() != null && mailTemplate.getTemplateTitle().length() > 255 || mailTemplate.getTemplateName() != null && mailTemplate.getTemplateName().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (!mailTemplate.getBusinessType().matches("[\\w\\_]+")) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
        }
        mailTemplate.setModifyDate(new Date());
        this.mailTemplateService.modifyObj(mailTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u90ae\u4ef6\u6a21\u677f\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mailTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u90ae\u4ef6\u6a21\u677f\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MailTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MailTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MailTemplateExample example = new MailTemplateExample();
        example.setPageView((PageView<MailTemplate>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_DATE DESC");
        if (wapper != null) {
            MailTemplateExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mailTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

