/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.mail.dao.MailTemplateMapper;
import com.els.base.msg.mail.entity.MailTemplate;
import com.els.base.msg.mail.entity.MailTemplateExample;
import com.els.base.msg.mail.service.MailTemplateService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMailTemplateService")
public class MailTemplateServiceImpl
implements MailTemplateService {
    @Resource
    protected MailTemplateMapper mailTemplateMapper;

    @CacheEvict(value={"mailTemplate"}, allEntries=true)
    public void addObj(MailTemplate t) {
        Assert.isNotBlank((String)t.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getTemplateTitle(), (String)"\u90ae\u4ef6\u6a21\u677f\u7684\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getTemplateContent(), (String)"\u90ae\u4ef6\u6a21\u677f\u7684\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getTemplateName(), (String)"\u90ae\u4ef6\u6a21\u677f\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getTemplateNum(), (String)"\u90ae\u4ef6\u6a21\u677f\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MailTemplateExample example = new MailTemplateExample();
        example.createCriteria().andBusinessTypeEqualTo(t.getBusinessType());
        if (this.mailTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u6a21\u677f\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        example.clear();
        example.createCriteria().andTemplateNumEqualTo(t.getTemplateNum());
        if (this.mailTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("\u5df2\u7ecf\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6a21\u677f\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        t.setCreateDate(new Date());
        t.setModifyDate(new Date());
        this.mailTemplateMapper.insertSelective(t);
    }

    @CacheEvict(value={"mailTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mailTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mailTemplate"}, allEntries=true)
    public void modifyObj(MailTemplate mailTemplate) {
        if (StringUtils.isBlank((String)mailTemplate.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        MailTemplateExample example = new MailTemplateExample();
        example.createCriteria().andBusinessTypeEqualTo(mailTemplate.getBusinessType()).andIdNotEqualTo(mailTemplate.getId());
        if (this.mailTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u6a21\u677f\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        example.clear();
        example.createCriteria().andTemplateNumEqualTo(mailTemplate.getTemplateNum()).andIdNotEqualTo(mailTemplate.getId());
        if (this.mailTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("\u5df2\u7ecf\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6a21\u677f\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        mailTemplate.setCompanyId(null);
        mailTemplate.setProjectId(null);
        mailTemplate.setCreateDate(null);
        mailTemplate.setModifyDate(new Date());
        this.mailTemplateMapper.updateByPrimaryKeySelective(mailTemplate);
    }

    @Cacheable(value={"mailTemplate"}, keyGenerator="redisKeyGenerator")
    public MailTemplate queryObjById(String id) {
        return this.mailTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mailTemplate"}, keyGenerator="redisKeyGenerator")
    public List<MailTemplate> queryAllObjByExample(MailTemplateExample example) {
        return this.mailTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"mailTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<MailTemplate> queryObjByPage(MailTemplateExample example) {
        PageView<MailTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.mailTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"mailTemplate"}, keyGenerator="redisKeyGenerator")
    public MailTemplate queryMailTemplateByBusinessType(String businessType) {
        MailTemplateExample mailTemplateExample = new MailTemplateExample();
        mailTemplateExample.createCriteria().andBusinessTypeEqualTo(businessType);
        List<MailTemplate> mailTemplateList = this.mailTemplateMapper.selectByExample(mailTemplateExample);
        if (CollectionUtils.isEmpty(mailTemplateList)) {
            return null;
        }
        return mailTemplateList.get(0);
    }

    @CacheEvict(value={"mailTemplate"}, allEntries=true)
    public void deleteByExample(MailTemplateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mailTemplateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mailTemplate"}, allEntries=true)
    @Transactional
    public void addAll(List<MailTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.mailTemplateMapper.insertSelective((MailTemplate)record));
    }
}

