/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class MessageSendUtils {
    private static Logger logger = LoggerFactory.getLogger(MessageSendUtils.class);

    public static void sendMessage(Message<?> message) {
        message.checkData();
        MsgConfigService msgConfigService = (MsgConfigService)SpringContextHolder.getOneBean(MsgConfigService.class);
        List<IMessageCommand> senderList = msgConfigService.querySender(message);
        MessageSendUtils.sendMessage(senderList, message);
    }

    private static void sendMessage(List<IMessageCommand> senderList, final Message<?> message) {
        if (CollectionUtils.isEmpty(senderList)) {
            return;
        }
        ThreadPoolTaskExecutor threadPool = (ThreadPoolTaskExecutor)SpringContextHolder.getOneBean(ThreadPoolTaskExecutor.class);
        for (int i = 0; i < senderList.size(); ++i) {
            final IMessageCommand sender = senderList.get(i);
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("\u6267\u884c\u6d88\u606f\u547d\u4ee4:" + sender.getClass());
                    try {
                        sender.sendMsg(message);
                    }
                    catch (Exception e) {
                        logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u53d1\u9001\u5668[" + sender.getClass() + "]", (Throwable)e);
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        Message<String> message = Message.init("abc").setBusinessTypeCode("JIT_PLAN_SEND").setCompanyCode("5000234").setMsgLevel(MessageLevelEnum.HIGH).setSenderId(SpringSecurityUtils.getLoginUserId()).addReceiverId("123123").addReceiverIdList(new ArrayList<String>());
        MessageSendUtils.sendMessage(message);
    }
}

