/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.im.entity.TitleVo;
import com.els.base.websitemsg.entity.WebsiteMsg;
import com.els.base.websitemsg.entity.WebsiteMsgExample;
import com.els.base.websitemsg.service.WebsiteMsgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u7cfb\u7edf\u6d88\u606f"})
@Controller
@RequestMapping(value={"websiteMsg"})
public class WebsiteMsgController {
    @Resource
    protected WebsiteMsgService websiteMsgService;
    @Resource
    protected DicGroupItemService dicGroupItemService;
    @Resource
    protected DicGroupService dicGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7cfb\u7edf\u6d88\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WebsiteMsg websiteMsg) {
        this.websiteMsgService.addObj(websiteMsg);
        return ResponseResult.success((Object)websiteMsg.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7cfb\u7edf\u6d88\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WebsiteMsg websiteMsg) {
        Assert.isNotBlank((String)websiteMsg.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.websiteMsgService.modifyObj(websiteMsg);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u6807\u8bb0\u4e3a\u5df2\u8bfb\u4fe1\u606f")
    @RequestMapping(value={"service/editRead"})
    @ResponseBody
    public ResponseResult<String> editRead(@RequestBody List<WebsiteMsg> websiteMsg) {
        Assert.isNotEmpty(websiteMsg, (String)"\u81f3\u5c11\u9700\u8981\u9009\u4e2d\u4e00\u6761\u6570\u636e\uff01");
        List ids = websiteMsg.stream().map(WebsiteMsg::getId).collect(Collectors.toList());
        Assert.isNotEmpty(ids, (String)"\u81f3\u5c11\u9700\u8981\u9009\u4e2d\u4e00\u6761\u6570\u636e!");
        WebsiteMsgExample example = new WebsiteMsgExample();
        example.createCriteria().andIdIn(ids);
        WebsiteMsg msg = new WebsiteMsg();
        msg.setReader(Constant.YES_INT);
        this.websiteMsgService.updateByExampleSelective(msg, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7cfb\u7edf\u6d88\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        WebsiteMsgExample example = new WebsiteMsgExample();
        example.createCriteria().andIdIn((List)ids);
        this.websiteMsgService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7cfb\u7edf\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 WebsiteMsg", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WebsiteMsg>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(defaultValue="0") Integer state, @RequestBody(required=false) QueryParamWapper wapper) {
        WebsiteMsgExample example = new WebsiteMsgExample();
        example.setOrderByClause("CREATE_TIME desc");
        example.setPageView((PageView<WebsiteMsg>)new PageView(pageNo, pageSize));
        WebsiteMsgExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (!state.equals(2)) {
            criteria.andReaderEqualTo(state);
        }
        criteria.andReceiveridEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView pageData = this.websiteMsgService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u6d88\u606f\u7c7b\u578b", httpMethod="POST")
    @RequestMapping(value={"service/queryType"})
    @ResponseBody
    public ResponseResult<List<TitleVo>> queryTypes() {
        List<TitleVo> titleVos = this.websiteMsgService.quertConut(SpringSecurityUtils.getLoginUserId());
        if (CollectionUtils.isEmpty(titleVos)) {
            titleVos = this.title();
            return ResponseResult.success(titleVos);
        }
        return ResponseResult.success(titleVos);
    }

    private List<TitleVo> title() {
        ArrayList<TitleVo> listTitle = new ArrayList<TitleVo>();
        DicGroupExample dicGroupExample = new DicGroupExample();
        dicGroupExample.createCriteria().andCodeEqualTo("template_type");
        List dicGroups = this.dicGroupService.queryAllObjByExample(dicGroupExample);
        List dicCode = dicGroups.stream().map(DicGroup::getId).distinct().collect(Collectors.toList());
        if (dicCode.isEmpty()) {
            return listTitle;
        }
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdIn(dicCode).andDescriptionEqualTo("\u9ed8\u8ba4\u4ee3\u529e");
        List dicGroupItems = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
        for (DicGroupItem dicGroupItem : dicGroupItems) {
            TitleVo titleVo = new TitleVo();
            titleVo.setTitle(dicGroupItem.getName());
            titleVo.setNumbers("0");
            listTitle.add(titleVo);
        }
        return listTitle;
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e")
    @RequestMapping(value={"service/list"})
    @ResponseBody
    public ResponseResult<List<WebsiteMsg>> list(@RequestBody(required=false) QueryParamWapper wapper) {
        WebsiteMsgExample example = new WebsiteMsgExample();
        example.setOrderByClause("CREATE_TIME desc");
        WebsiteMsgExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            String paramValue = wapper.getParamValue("msgType");
            if (paramValue != null) {
                wapper.removeParam(paramValue);
            }
            DicGroupExample dicGroupExample = new DicGroupExample();
            dicGroupExample.createCriteria().andCodeEqualTo("template_type");
            List dicGroups = this.dicGroupService.queryAllObjByExample(dicGroupExample);
            List dicCode = dicGroups.stream().map(DicGroup::getId).distinct().collect(Collectors.toList());
            DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
            dicGroupItemExample.createCriteria().andGroupIdIn(dicCode).andDescriptionEqualTo("\u9ed8\u8ba4\u4ee3\u529e");
            List dicGroupItems = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
            List collect = dicGroupItems.stream().filter(dicGroupItem -> paramValue.equals(dicGroupItem.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                example.createCriteria().andMsgTypeEqualTo(((DicGroupItem)collect.get(0)).getCode());
            }
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andReceiveridEqualTo(SpringSecurityUtils.getLoginUserId());
        List pageData = this.websiteMsgService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u6570\u91cf", notes="\u4e0d\u4f20\u67e5\u8be2\u5168\u90e8\u6d88\u606f\uff0c\u4f201\uff0c\u67e5\u8be2\u5df2\u8bfb\u6570\u636e\uff0c\u4f200 \u67e5\u8be2\u672a\u8bfb\u6570\u636e")
    @RequestMapping(value={"service/count"})
    @ResponseBody
    public ResponseResult<Integer> count(@RequestParam(required=false) Integer flag) {
        WebsiteMsgExample example = new WebsiteMsgExample();
        WebsiteMsgExample.Criteria criteria = example.createCriteria();
        criteria.andReceiveridEqualTo(SpringSecurityUtils.getLoginUserId());
        if (Constant.NO_INT.equals(flag)) {
            criteria.andReaderEqualTo(Constant.NO_INT);
        }
        if (Constant.YES_INT.equals(flag)) {
            criteria.andReaderEqualTo(Constant.YES_INT);
        }
        Integer pageData = this.websiteMsgService.countByExample(example);
        return ResponseResult.success((Object)pageData);
    }
}

