/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.weixin.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.qrcode.service.WxQrcodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u6d88\u606f\u7ba1\u7406-\u5fae\u4fe1\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801\u7ed1\u5b9a")
@Controller
@RequestMapping(value={"wxQrcode"})
public class WxQrcodeController {
    @Resource
    private WxQrcodeService wxQrcodeService;

    @ApiOperation(httpMethod="GET", value="\u521b\u5efa\u5f53\u524d\u7528\u6237\u7684\u516c\u4f17\u53f7\u7ed1\u5b9a\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/createQrcodeForCurrentUser"})
    @ResponseBody
    public ModelAndView createQrcodeForCurrentUser(HttpServletResponse response) throws WxErrorException, IOException {
        String userId = SpringSecurityUtils.getLoginUserId();
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount((AccountConfig)WxAccountConfigUtils.getDefaultAccountFromConfig());
        String sceneStr = "BIND_USER_" + userId;
        WxMpQrcodeService qrcodeService = wxMpService.getQrcodeService();
        WxMpQrCodeTicket ticket = qrcodeService.qrCodeCreateTmpTicket(sceneStr, Integer.valueOf(1800));
        File file = qrcodeService.qrCodePicture(ticket);
        response.addHeader("Content-Disposition", "inline;filename=\"" + URLEncoder.encode("qrcode.jpg", "UTF-8") + "\";");
        response.setContentType("image/jpg");
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] tmp = new byte[1024];
        FileInputStream inputStream = new FileInputStream(file);
        while (((InputStream)inputStream).read(tmp) != -1) {
            outputStream.write(tmp);
        }
        outputStream.flush();
        outputStream.close();
        ((InputStream)inputStream).close();
        return null;
    }
}

