/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.util;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.IMessage;
import com.els.base.msg.MessageLevelEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLiby<T>
implements IMessage<T>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MessageLiby.class);
    private static final long serialVersionUID = 1L;
    private String senderId;
    private List<String> receiverIdList;
    private String businessTypeCode;
    private MessageLevelEnum msgLevel;
    private String companyCode;
    private T data;

    public MessageLiby(String sendCompanyCode, String senderId, String receiverId, String businessTypeCode, MessageLevelEnum msgLevel, T data) {
        this.data = data;
        this.businessTypeCode = businessTypeCode;
        this.senderId = senderId;
        this.msgLevel = msgLevel;
        this.companyCode = sendCompanyCode;
        ArrayList<String> receiverIds = new ArrayList<String>();
        receiverIds.add(receiverId);
        this.receiverIdList = receiverIds;
    }

    private MessageLiby(T data) {
        this.data = data;
    }

    @Override
    public String getSenderId() {
        return this.senderId;
    }

    public MessageLiby<T> setSenderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public List<String> getReceiverIdList() {
        return this.receiverIdList;
    }

    public MessageLiby<T> addReceiverIdList(List<String> receiverIdList) {
        if (this.receiverIdList == null) {
            this.receiverIdList = new ArrayList<String>();
        }
        this.receiverIdList.addAll(receiverIdList);
        return this;
    }

    public MessageLiby<T> addReceiverId(String receiverId) {
        if (this.receiverIdList == null) {
            this.receiverIdList = new ArrayList<String>();
        }
        this.receiverIdList.add(receiverId);
        return this;
    }

    @Override
    public MessageLevelEnum getMsgLevel() {
        return this.msgLevel;
    }

    public MessageLiby<T> setMsgLevel(MessageLevelEnum msgLevel) {
        this.msgLevel = msgLevel;
        return this;
    }

    @Override
    public String getCompanyCode() {
        return this.companyCode;
    }

    public MessageLiby<T> setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    @Override
    public String getBusinessTypeCode() {
        return this.businessTypeCode;
    }

    public MessageLiby<T> setBusinessTypeCode(String businessTypeCode) {
        this.businessTypeCode = businessTypeCode;
        return this;
    }

    public void checkData() {
        try {
            Assert.isNotBlank((String)this.getCompanyCode(), (String)"companyCode\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull(this.data, (String)"\u6d88\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotEmpty(this.receiverIdList, (String)"\u6d88\u606f\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new CommonException((Throwable)e);
        }
    }

    public void checkDataWebsite() {
        try {
            Assert.isNotNull(this.data, (String)"\u6d88\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotEmpty(this.receiverIdList, (String)"\u6d88\u606f\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)this.businessTypeCode, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new CommonException((Throwable)e);
        }
    }

    public static <T> MessageLiby<T> init(T data) {
        MessageLiby<T> message = new MessageLiby<T>(data);
        return message;
    }
}

