/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im.util;

import com.els.base.core.exception.CommonException;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.im.util.ImMessagePushProperties;
import com.els.base.msg.im.util.MessagePageRedirectEnum;
import com.els.base.utils.SpringContextHolder;
import com.qqt.message.client.MessageClient;
import com.qqt.message.client.MessagePageVO;
import com.qqt.message.client.UserMessageExample;
import com.qqt.message.client.impl.MessageClientImpl;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessageUtils.class);
    private static final MessageUtils instance = new MessageUtils();
    public static final String TYPE_SYSTEM = "system";
    private MessageClient client = null;

    private MessageUtils() {
        try {
            if (this.client == null) {
                ImMessagePushProperties properties = (ImMessagePushProperties)SpringContextHolder.getOneBean(ImMessagePushProperties.class);
                if (StringUtils.isBlank((String)properties.getHost())) {
                    throw new CommonException("\u6d88\u606f\u670d\u52a1\u5668IP\u672a\u914d\u7f6e");
                }
                this.client = new MessageClientImpl(properties.getAccessToken(), properties.getAddUrl(), properties.getReadUrl(), properties.getListUrl(), properties.getCountUrl(), properties.getListAllUrl());
            }
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u5de5\u5177\u7c7b\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    public MessageClient getClient() {
        return this.client;
    }

    public static MessagePageVO listMessage(int pageNumber, int pageSize, UserMessageExample example, Map<String, String> sorts) throws ConnectException {
        return instance.getClient().listMessage(pageNumber, pageSize, example, sorts);
    }

    public static void markMsg2Read(String msgId, String account) throws ConnectException {
        instance.getClient().markMsg2Read(msgId, account);
    }

    @Deprecated
    public static void pushMessage(String title, String content, String type, Set<String> accounts, Map<String, String> extras, String companyCode, String sender) throws ConnectException {
        try {
            instance.getClient().pushMessage(title, content, type, accounts, extras, companyCode, sender);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001im\u7684\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Deprecated
    public static void pushSystemMessage(String title, String content, Set<String> accounts, String companyCode, MessageLevelEnum level) throws ConnectException {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("level", level.getLevel());
        MessageUtils.pushMessage(title, content, TYPE_SYSTEM, accounts, extras, companyCode, null);
    }

    @Deprecated
    public static void pushSystemMessage(String title, String content, String receiver, String companyCode, MessageLevelEnum level) throws ConnectException {
        if (StringUtils.isBlank((String)receiver)) {
            return;
        }
        HashSet<String> accounts = new HashSet<String>();
        accounts.add(receiver);
        MessageUtils.pushSystemMessage(title, content, accounts, companyCode, level);
    }

    @Deprecated
    public static void pushSystemMessage(String title, String content, Set<String> accounts, String companyCode, MessageLevelEnum level, MessagePageRedirectEnum page, String sender, Map<String, String> extras) throws ConnectException {
        if (accounts == null || accounts.isEmpty()) {
            return;
        }
        if (extras == null) {
            extras = new HashMap<String, String>();
        }
        extras.put("level", level.getLevel());
        extras.put("page", page.getPage());
        MessageUtils.pushMessage(title, content, TYPE_SYSTEM, accounts, extras, companyCode, sender);
    }
}

