/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.im.dao.ImTemplateLibyMapper;
import com.els.base.msg.im.entity.ImTemplateLiby;
import com.els.base.msg.im.entity.ImTemplateLibyExample;
import com.els.base.msg.im.service.ImTemplateLibyService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultImTemplateLibyService")
public class ImTemplateLibyServiceImpl
implements ImTemplateLibyService {
    @Resource
    protected ImTemplateLibyMapper imTemplateLibyMapper;

    @CacheEvict(value={"imTemplateLiby"}, allEntries=true)
    public void addObj(ImTemplateLiby t) {
        this.imTemplateLibyMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"imTemplateLiby"}, allEntries=true)
    public void addAll(List<ImTemplateLiby> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.imTemplateLibyMapper.insertBatch(list);
    }

    @CacheEvict(value={"imTemplateLiby"}, allEntries=true)
    public void deleteObjById(String id) {
        this.imTemplateLibyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"imTemplateLiby"}, allEntries=true)
    public void deleteByExample(ImTemplateLibyExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.imTemplateLibyMapper.deleteByExample(example);
    }

    @CacheEvict(value={"imTemplateLiby"}, allEntries=true)
    public void modifyObj(ImTemplateLiby t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.imTemplateLibyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"imTemplateLiby"}, keyGenerator="redisKeyGenerator")
    public ImTemplateLiby queryObjById(String id) {
        return this.imTemplateLibyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"imTemplateLiby"}, keyGenerator="redisKeyGenerator")
    public List<ImTemplateLiby> queryAllObjByExample(ImTemplateLibyExample example) {
        return this.imTemplateLibyMapper.selectByExample(example);
    }

    @Cacheable(value={"imTemplateLiby"}, keyGenerator="redisKeyGenerator")
    public PageView<ImTemplateLiby> queryObjByPage(ImTemplateLibyExample example) {
        PageView<ImTemplateLiby> pageView = example.getPageView();
        pageView.setQueryResult(this.imTemplateLibyMapper.selectByExampleByPage(example));
        return pageView;
    }
}

