/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.im.entity.ImTemplateLiby;
import com.els.base.msg.im.entity.TitleVo;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.websitemsg.dao.WebsiteMsgMapper;
import com.els.base.websitemsg.entity.WebsiteMsg;
import com.els.base.websitemsg.entity.WebsiteMsgExample;
import com.els.base.websitemsg.service.WebsiteMsgService;
import com.els.base.websitemsg.util.MessageLiby;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultWebsiteMsgService")
public class WebsiteMsgServiceImpl
implements WebsiteMsgService {
    @Resource
    protected WebsiteMsgMapper websiteMsgMapper;
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_PERSONAL = "personal";
    @Resource
    protected DicGroupItemService dicGroupItemService;
    @Resource
    protected DicGroupService dicGroupService;

    @Override
    @Transactional
    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public int updateByExampleSelective(WebsiteMsg record, WebsiteMsgExample example) {
        return this.websiteMsgMapper.updateByExampleSelective(record, example);
    }

    @Override
    public int countByExample(WebsiteMsgExample example) {
        return this.websiteMsgMapper.countByExample(example);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void addObj(WebsiteMsg t) {
        this.websiteMsgMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void addAll(List<WebsiteMsg> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.websiteMsgMapper.insertBatch(list);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void deleteObjById(String id) {
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void deleteByExample(WebsiteMsgExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.websiteMsgMapper.deleteByExample(example);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void modifyObj(WebsiteMsg t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
    }

    @Cacheable(value={"websiteMsg"}, keyGenerator="redisKeyGenerator")
    public WebsiteMsg queryObjById(String id) {
        return null;
    }

    public List<WebsiteMsg> queryAllObjByExample(WebsiteMsgExample example) {
        return this.websiteMsgMapper.selectByExample(example);
    }

    public PageView<WebsiteMsg> queryObjByPage(WebsiteMsgExample example) {
        PageView<WebsiteMsg> pageView = example.getPageView();
        pageView.setQueryResult(this.websiteMsgMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void createMsg(MessageLiby<?> message, String websiteContent, MsgConfig msgConfig, ImTemplateLiby imTemplate) {
        Set<String> accounts = this.getAccount(message.getReceiverIdList());
        String senderId = message.getSenderId();
        MessageLevelEnum msgLevel = message.getMsgLevel();
        String msgType = TYPE_PERSONAL;
        if (StringUtils.isBlank((String)senderId)) {
            senderId = "systemDefaultSender";
            msgType = TYPE_SYSTEM;
        }
        DicGroupExample dicGroupExample = new DicGroupExample();
        dicGroupExample.createCriteria().andCodeEqualTo("business_type");
        List dicGroups = this.dicGroupService.queryAllObjByExample(dicGroupExample);
        List dicCode = dicGroups.stream().map(DicGroup::getId).distinct().collect(Collectors.toList());
        List dicGroupItems = new ArrayList();
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        if (CollectionUtils.isNotEmpty(dicCode)) {
            dicGroupItemExample.createCriteria().andGroupIdIn(dicCode).andCodeEqualTo(imTemplate.getBusinessType());
            dicGroupItems = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
        }
        for (String reString : accounts) {
            WebsiteMsg websiteMsg = new WebsiteMsg();
            websiteMsg.setSender(senderId);
            websiteMsg.setReceiverid(reString);
            websiteMsg.setContent(websiteContent);
            websiteMsg.setTitle(msgConfig.getBusinessType());
            if (CollectionUtils.isNotEmpty(dicGroupItems)) {
                websiteMsg.setTitle(((DicGroupItem)dicGroupItems.get(0)).getName());
            }
            websiteMsg.setReader(Constant.NO_INT);
            websiteMsg.setCreateTime(new Date());
            websiteMsg.setUpdateTime(new Date());
            websiteMsg.setType(msgType);
            websiteMsg.setDeleted(Constant.YES_INT);
            websiteMsg.setMsgLevel(msgLevel.getLevel());
            websiteMsg.setMsgType(imTemplate.getTemplateType());
            websiteMsg.setAttribute2(imTemplate.getBusinessType());
            websiteMsg.setPageParam(imTemplate.getPageParam());
            websiteMsg.setPage(imTemplate.getPage());
            this.websiteMsgMapper.insertSelective(websiteMsg);
        }
    }

    private Set<String> getAccount(List<String> receiverIdList) {
        HashSet<String> accounts = new HashSet<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(receiverIdList) && i < receiverIdList.size(); ++i) {
            accounts.add(receiverIdList.get(i));
        }
        return accounts;
    }

    @Override
    public List<TitleVo> quertConut(String receiverid) {
        return this.websiteMsgMapper.querycount(receiverid);
    }
}

