/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.util;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.msg.im.entity.ImTemplateLiby;
import com.els.base.msg.im.entity.ImTemplateLibyExample;
import com.els.base.msg.im.service.ImTemplateLibyService;
import com.els.base.msg.mail.MailMessageCommand;
import com.els.base.msg.weixin.WeixinMessageCommand;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.websitemsg.service.WebsiteMsgService;
import com.els.base.websitemsg.util.MessageLiby;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class WebsiteMsgUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebsiteMsgUtils.class);

    private static ImTemplateLibyService geImTemplateService() {
        return (ImTemplateLibyService)SpringContextHolder.getOneBean(ImTemplateLibyService.class);
    }

    private static WebsiteMsgService getWebsiteMsgService() {
        return (WebsiteMsgService)SpringContextHolder.getOneBean(WebsiteMsgService.class);
    }

    private static MsgConfigService getMsgConfigService() {
        return (MsgConfigService)SpringContextHolder.getOneBean(MsgConfigService.class);
    }

    public static void sendMessage(MessageLiby<?> message) {
        message.checkDataWebsite();
        MsgConfigExample msgConfigExample = new MsgConfigExample();
        msgConfigExample.createCriteria().andBusinessTypeEqualTo(message.getBusinessTypeCode()).andSysMsgEqualTo(Constant.YES_INT);
        List msgConfigs = WebsiteMsgUtils.getMsgConfigService().queryAllObjByExample((IExample)msgConfigExample);
        if (CollectionUtils.isEmpty((Collection)msgConfigs)) {
            logger.warn("\u6ca1\u6709\u5f00\u542f\u7cfb\u7edf\u6d88\u606f\u529f\u80fd");
            return;
        }
        MailMessageCommand mailCommand = new MailMessageCommand();
        WeixinMessageCommand weixinCommand = new WeixinMessageCommand();
        ArrayList<IMessageCommand> commandList = new ArrayList<IMessageCommand>();
        for (MsgConfig config : msgConfigs) {
            if (Constant.YES_INT.equals(config.getMailMsg()) && !commandList.contains(mailCommand)) {
                commandList.add(mailCommand);
            }
            if (!Constant.YES_INT.equals(config.getWeixinMsg()) || commandList.contains(weixinCommand)) continue;
            commandList.add(weixinCommand);
        }
        Message<?> messages = Message.init(message.getData()).setBusinessTypeCode(message.getBusinessTypeCode()).setCompanyCode(message.getCompanyCode()).setMsgLevel(message.getMsgLevel()).setSenderId(message.getSenderId()).addReceiverIdList(message.getReceiverIdList());
        WebsiteMsgUtils.sendMessage(commandList, messages);
        WebsiteMsgUtils.sendMsg(msgConfigs, message);
    }

    private static void sendMessage(List<IMessageCommand> senderList, final Message<?> message) {
        if (CollectionUtils.isEmpty(senderList)) {
            return;
        }
        ThreadPoolTaskExecutor threadPool = (ThreadPoolTaskExecutor)SpringContextHolder.getOneBean(ThreadPoolTaskExecutor.class);
        for (int i = 0; i < senderList.size(); ++i) {
            final IMessageCommand sender = senderList.get(i);
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("\u6267\u884c\u6d88\u606f\u547d\u4ee4:" + sender.getClass());
                    try {
                        sender.sendMsg(message);
                    }
                    catch (Exception e) {
                        logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u53d1\u9001\u5668[" + sender.getClass() + "]", (Throwable)e);
                    }
                }
            });
        }
    }

    private static void sendMsg(List<MsgConfig> msgConfigs, MessageLiby<?> message) {
        String businessTypeCode = message.getBusinessTypeCode();
        ImTemplateLibyExample example = new ImTemplateLibyExample();
        example.createCriteria().andBusinessTypeEqualTo(businessTypeCode);
        List imTemplateList = WebsiteMsgUtils.geImTemplateService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)imTemplateList)) {
            logger.warn("\u7cfb\u7edf\u6d88\u606f\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        ImTemplateLiby imTemplate = (ImTemplateLiby)imTemplateList.get(0);
        String websiteContent = imTemplate.getTemplateContent();
        try {
            websiteContent = BeetlTemplateUtils.renderFromString((String)websiteContent, (String)"message", message);
            imTemplate.setTemplateContent(websiteContent);
            if (StringUtils.isNotBlank((String)imTemplate.getPageParam())) {
                String pageParam = BeetlTemplateUtils.renderFromString((String)imTemplate.getPageParam(), (String)"message", message);
                imTemplate.setPageParam(pageParam);
            }
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u6d88\u606f\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        WebsiteMsgUtils.getWebsiteMsgService().createMsg(message, websiteContent, msgConfigs.get(0), imTemplate);
    }

    public static void main(String[] args) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("orderNo", "10086");
        MessageLiby message = MessageLiby.init(data).setBusinessTypeCode("TEST").setMsgLevel(MessageLevelEnum.HIGH).setSenderId(SpringSecurityUtils.getLoginUserId()).addReceiverId(SpringSecurityUtils.getLoginUserId()).addReceiverIdList(new ArrayList<String>());
        WebsiteMsgUtils.sendMessage(message);
    }
}

