/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.weixin.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.ResponseCode;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.oauth.web.controller.WechatOauthController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1-\u4f1a\u5458\u8d44\u6599")
@RequestMapping(value={"wxMember"})
@Controller(value="msgWxMemberController")
public class WxMemberController {
    @Autowired
    private WxMemberService wxMemberService;
    @Autowired
    private WechatOauthController wechatOauthController;

    @ApiOperation(value="\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u7ed1\u5b9a", httpMethod="GET")
    @RequestMapping(value={"front/isTie"})
    @ResponseBody
    public ResponseResult<String> isTie(@ApiParam(value="\u6388\u6743\u7684\u9875\u9762") String url, HttpServletRequest request) throws Exception {
        String openid = (String)request.getSession().getAttribute("openid");
        if (StringUtils.isBlank((String)openid)) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_No_Login).setMsg("\u5fae\u4fe1\u5e10\u53f7\u672a\u8df3\u8f6c\u767b\u5f55").setData(this.wechatOauthController.createOauthUrlForOpenid(url, null, request).getData());
        }
        WxMember wxMemeber = this.wxMemberService.queryByOpenId(openid);
        if (wxMemeber == null) {
            throw new CommonException("\u5fae\u4fe1\u5e10\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u5173\u6ce8\u516c\u4f17\u53f7");
        }
        if (StringUtils.isBlank((String)wxMemeber.getMemberId())) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_Permission_denied).setMsg("\u5fae\u4fe1\u5e10\u53f7\u672a\u7ed1\u5b9a");
        }
        User user = SpringSecurityUtils.getLoginUser();
        if (user == null) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Account_No_Login).setMsg("\u5fae\u4fe1\u5e10\u53f7\u672a\u8df3\u8f6c\u767b\u5f55").setData(this.wechatOauthController.createOauthUrlForOpenid(url, null, request).getData());
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u7ed1\u5fae\u4fe1", httpMethod="GET")
    @RequestMapping(value={"front/untiedMemberId"})
    @ResponseBody
    public ResponseResult<String> untiedMemberId(@ApiParam(value="\u5fae\u4fe1\u4f1a\u5458id") String id) {
        this.wxMemberService.unTieMemberId(id);
        return ResponseResult.success();
    }
}

