/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.dictonary.DicUtils;
import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.im.entity.ImTemplateLiby;
import com.els.base.msg.im.entity.ImTemplateLibyExample;
import com.els.base.msg.im.service.ImTemplateLibyService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.websitemsg.entity.WebsiteMsg;
import com.els.base.websitemsg.service.WebsiteMsgService;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImMessageCommand
implements IMessageCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ImMessageCommand.class);
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_PERSONAL = "personal";

    private static WebsiteMsgService getWebsiteMsgService() {
        return (WebsiteMsgService)SpringContextHolder.getOneBean(WebsiteMsgService.class);
    }

    private static ImTemplateLibyService getImTemplateLibyService() {
        return (ImTemplateLibyService)SpringContextHolder.getOneBean(ImTemplateLibyService.class);
    }

    @Override
    public void sendMsg(IMessage<?> message) throws Exception {
        Set<String> accounts = this.getAccount(message.getReceiverIdList());
        String companyCode = "";
        if (StringUtils.isNotBlank((String)message.getCompanyCode())) {
            companyCode = message.getCompanyCode();
        }
        String businessTypeCode = message.getBusinessTypeCode();
        if (CollectionUtils.isEmpty(accounts)) {
            logger.warn("\u63a5\u6536\u4eba\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        ImTemplateLibyExample example = new ImTemplateLibyExample();
        example.createCriteria().andBusinessTypeEqualTo(businessTypeCode);
        List imTemplateList = ImMessageCommand.getImTemplateLibyService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)imTemplateList)) {
            return;
        }
        ImTemplateLiby imTemplate = (ImTemplateLiby)imTemplateList.get(0);
        String imContent = imTemplate.getTemplateContent();
        try {
            imContent = BeetlTemplateUtils.renderFromString((String)imContent, (String)"message", message);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u6d88\u606f\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        String senderId = "systemDefaultSender";
        MessageLevelEnum msgLevel = message.getMsgLevel();
        String msgType = TYPE_PERSONAL;
        if (StringUtils.isNotBlank((String)message.getSenderId())) {
            senderId = message.getSenderId();
            msgType = TYPE_SYSTEM;
        }
        DicGroupItem dicGroupItems = DicUtils.getDicGroupItemByCode((String)"business_type", (String)message.getBusinessTypeCode());
        for (String reString : accounts) {
            WebsiteMsg websiteMsg = new WebsiteMsg();
            websiteMsg.setSender(senderId);
            websiteMsg.setReceiverid(reString);
            websiteMsg.setContent(imContent);
            websiteMsg.setTitle(imTemplate.getBusinessType());
            if (dicGroupItems != null) {
                websiteMsg.setTitle(dicGroupItems.getName());
            }
            websiteMsg.setReader(Constant.NO_INT);
            websiteMsg.setCreateTime(new Date());
            websiteMsg.setUpdateTime(new Date());
            websiteMsg.setType(msgType);
            websiteMsg.setDeleted(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)msgLevel.getLevel())) {
                websiteMsg.setMsgLevel(msgLevel.getLevel());
            }
            websiteMsg.setMsgType(imTemplate.getTemplateType());
            websiteMsg.setAttribute1(companyCode);
            websiteMsg.setAttribute2(imTemplate.getBusinessType());
            if (StringUtils.isNotBlank((String)imTemplate.getPageParam())) {
                websiteMsg.setPageParam(BeetlTemplateUtils.renderFromString((String)imTemplate.getPageParam(), (String)"message", message));
            }
            websiteMsg.setPage(BeetlTemplateUtils.renderFromString((String)imTemplate.getPage(), (String)"message", message));
            ImMessageCommand.getWebsiteMsgService().addObj(websiteMsg);
        }
    }

    private Set<String> getAccount(List<String> receiverIdList) {
        HashSet<String> accounts = new HashSet<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(receiverIdList) && i < receiverIdList.size(); ++i) {
            accounts.add(receiverIdList.get(i));
        }
        return accounts;
    }
}

