/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.notice.command.BatchCancelCommand;
import com.els.base.notice.command.BatchPublishCommand;
import com.els.base.notice.command.CreateCommand;
import com.els.base.notice.command.DeleteCommand;
import com.els.base.notice.command.ImInvoker;
import com.els.base.notice.command.ModifyCommand;
import com.els.base.notice.command.PublishCommand;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="CMS-\u516c\u544a\u7ba1\u7406")
@Controller(value="cmsNoticeController")
@RequestMapping(value={"cmsNotice"})
public class NoticeController {
    @Resource
    protected NoticeService noticeService;
    @Resource
    protected NoticeReceiverService noticeReceiverService;
    @Resource
    protected ImInvoker noticeInvoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u516c\u544a")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Notice notice) {
        Assert.isNotNull((Object)notice, (String)"\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        notice.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        notice.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        CreateCommand createComand = new CreateCommand(notice);
        this.noticeInvoker.invoke(createComand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u516c\u544a")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Notice notice) {
        Assert.isNotBlank((String)notice.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyCommand modifyCommand = new ModifyCommand(notice);
        this.noticeInvoker.invoke(modifyCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u516c\u544a")
    @RequestMapping(value={"service/deleteBatch"})
    @ResponseBody
    public ResponseResult<String> deleteBatch(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteCommand deleteCommand = new DeleteCommand(ids);
        this.noticeInvoker.invoke(deleteCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u516c\u544a\u5c55\u793a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/show"})
    @ResponseBody
    public ResponseResult<PageView<Notice>> show(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, String companyId) {
        NoticeExample example = new NoticeExample();
        example.setPageView((PageView<Notice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("STICK DESC, PUBLISH_TIME DESC");
        NoticeExample.Criteria criteria = example.createCriteria();
        criteria.andStatusEqualTo(Constant.YES_INT).andValidStartTimeLessThanOrEqualTo(new Date());
        criteria.andIsAllReceivedEqualTo(Constant.YES_INT);
        this.orAsReceiver(example, companyId);
        PageView pageData = this.noticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    private void orAsReceiver(NoticeExample example, String companyId) {
        List<NoticeReceiver> list;
        NoticeReceiverExample noticeReceiverExample = new NoticeReceiverExample();
        if (StringUtils.isNotBlank((String)companyId)) {
            noticeReceiverExample.createCriteria().andReceiverCompanyIdEqualTo(companyId);
        }
        if (CollectionUtils.isEmpty(list = this.noticeReceiverService.queryAllObjByExample(noticeReceiverExample))) {
            return;
        }
        ArrayList<String> noticeIds = new ArrayList<String>(list.size());
        for (NoticeReceiver receiver : list) {
            noticeIds.add(receiver.getNoticeId());
        }
        example.or().andIdIn(noticeIds);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u516c\u544a\u5217\u8868\u67e5\u8be2--\u6162\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Notice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByAll"})
    @ResponseBody
    public ResponseResult<PageView<Notice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        NoticeExample example = new NoticeExample();
        example.setPageView((PageView<Notice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("STICK DESC, PUBLISH_TIME DESC");
        NoticeExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView<Notice> pageData = this.noticeService.queryObjByAll(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u516c\u544a\u5217\u8868\u67e5\u8be2-\u5feb\u901f\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Notice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Notice>> findByAll(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        NoticeExample example = new NoticeExample();
        example.setPageView((PageView<Notice>)new PageView(pageNo, pageSize));
        example.setOrderByClause("STICK DESC, PUBLISH_TIME DESC");
        NoticeExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.noticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"service/publish"})
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody Notice notice) {
        notice.setPublishUserId(SpringSecurityUtils.getLoginUserId());
        notice.setPublishUserName(SpringSecurityUtils.getLoginUser().getNickName());
        PublishCommand publishCommand = new PublishCommand(notice);
        this.noticeInvoker.invoke(publishCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6279\u91cf\u53d1\u5e03\u516c\u544a")
    @RequestMapping(value={"service/batchPublish"})
    @ResponseBody
    public ResponseResult<String> batchPublish(@RequestBody List<String> noticeIdList) {
        Assert.isNotEmpty(noticeIdList, (String)"\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        BatchPublishCommand publishCommand = new BatchPublishCommand(noticeIdList, (User)SpringSecurityUtils.getLoginUser());
        this.noticeInvoker.invoke(publishCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546-\u6279\u91cf\u4f5c\u5e9f\u516c\u544a")
    @RequestMapping(value={"service/batchCancel"})
    @ResponseBody
    public ResponseResult<String> batchCancel(@RequestBody List<String> noticeIdList) {
        Assert.isNotEmpty(noticeIdList, (String)"\u64a4\u9500\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        BatchCancelCommand batchCanCelCommand = new BatchCancelCommand(noticeIdList);
        this.noticeInvoker.invoke(batchCanCelCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u516c\u544a\u67e5\u770b\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<Notice> findById(@RequestParam(required=true) String id) {
        Notice notice = (Notice)this.noticeService.queryObjById(id);
        return ResponseResult.success((Object)notice);
    }

    @ApiOperation(httpMethod="POST", value="\u516c\u544a\u7f6e\u9876")
    @RequestMapping(value={"service/findByStick"})
    @ResponseBody
    public ResponseResult<String> findByStick(@RequestBody List<String> ids, Integer stick) {
        ids.forEach(id -> {
            NoticeExample example = new NoticeExample();
            example.createCriteria().andIdEqualTo((String)id);
            Notice notices = (Notice)this.noticeService.queryObjById(id);
            Notice notice = new Notice();
            notice.setId((String)id);
            if (stick == 1) {
                if (notices.getStatus() == 0) {
                    throw new CommonException("\u672a\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u7f6e\u9876");
                }
                if (notices.getStick() == 1) {
                    throw new CommonException("\u8be5\u516c\u544a\u5df2\u7ecf\u7f6e\u9876");
                }
                notice.setStick(1);
            } else {
                if (notices.getStatus() == 0) {
                    throw new CommonException("\u672a\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u53d6\u6d88\u7f6e\u9876");
                }
                if (notices.getStick() == 0) {
                    throw new CommonException("\u672a\u7f6e\u9876\u7684\u516c\u544a\u4e0d\u80fd\u53d6\u6d88\u7f6e\u9876");
                }
                notice.setStick(0);
            }
            this.noticeService.modifyObj(notice);
        });
        return ResponseResult.success();
    }
}

