package com.els.base.msg.weixin.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.encryption.DESUtils;
import com.els.base.wechat.login.entity.WxScanResults;
import com.els.base.wechat.login.service.WxScanResultsService;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;


@Api("微信扫码登录")
@Controller("wxScanLoginController")
@RequestMapping("wxScanLogin")
public class WxScanLoginController {

	@Autowired
	private UserService userService;
	
	@Autowired
	protected RoleService roleService;

	@Autowired
	protected AuthenticationManager authenticationManager;

	@Autowired
	protected WxScanResultsService wxScanResultsService;

	@Autowired
	private ApplicationContext applicationContext;


	/**
	 * 微信扫码登录结果轮询
	 * @param key
	 * @param request
	 * @return
	 */
	@ApiIgnore
	@RequestMapping("service/wxScanLogin")
	@ResponseBody
	public ResponseResult<String> loginForWxScan(@RequestParam(required=true) String key, HttpServletRequest request) {
		WxScanResults results = wxScanResultsService.queryUserIdByKey(key);
		if(results == null){
			return null;
		}
		if(results.getUserId() == null){
			throw new CommonException(String.format("登录失败，未关联用户"));
		}
		com.els.base.core.entity.user.User user = this.userService.queryObjById(results.getUserId());
		if (user == null) {
			throw new CommonException(String.format("登录失败，关联用户不存在"));
		}

		Authentication authentication = new UsernamePasswordAuthenticationToken(user.getLoginName(), getPassword(user));
        Authentication authResult = authenticationManager.authenticate(authentication);
        com.els.base.auth.entity.User userAuthed = (com.els.base.auth.entity.User) authResult.getPrincipal();
        Collection<GrantedAuthority> roleList = new ArrayList<>();
        for (Role grantedAuthority : this.roleService.queryUserOwnRoles(user.getId())) {
			
            roleList.add(new SimpleGrantedAuthority(grantedAuthority.getRoleName()));
        }
		userAuthed.setAuthorities(roleList);
		
		// 在当前访问线程中设置 authResult
		SecurityContextHolder.getContext().setAuthentication(authResult);
		request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", SecurityContextHolder.getContext());

		//触发登录成功事件，记录登录日志
		AuthenticationSuccessEvent event = new AuthenticationSuccessEvent(authResult);
		applicationContext.publishEvent(event);
		return ResponseResult.success();
	}
	
	private String getPassword(com.els.base.core.entity.user.User user) {
		Assert.isNotBlank(user.getPassword(), "帐号异常");
		
		String password = null;
		try {
			password = DESUtils.decrypt(user.getPassword(), Constant.SECRET_KEY);
			if (StringUtils.isNotBlank(user.getPasswordKey())) {
				password = password.replace(user.getPasswordKey(), "");
				password = DESUtils.decrypt(password, Constant.SECRET_KEY);
			}
		} catch (Exception e) {
			throw new CommonException("帐号异常", e);
		}
		
		return password;

	}
}
