package com.els.base.notice.command;

import java.util.List;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

public class BatchCancelCommand implements IMsgCommand<String> {

    private List<String> noticeIdList;

    public BatchCancelCommand(List<String> noticeIdList) {
        this.noticeIdList = noticeIdList;
    }

    @Override
    public String execute(ImInvoker invoker) {
        Assert.isNotEmpty(noticeIdList, "撤销的公告不能为空");

        NoticeExample noticeExample = new NoticeExample();
        noticeExample.createCriteria().andIdIn(noticeIdList);

        List<Notice> noticeLists = this.getNoticeService().queryAllObjByAllExample(noticeExample);
        for(Notice list : noticeLists){
            if(list.getStatus().equals(Constant.NO_INT)) {
                throw new CommonException("未发布的公告不能作废");
            }else {
                list.setStatus(Constant.NO_INT);
                list.setPublishUserId(null);
                list.setPublishUserName(null);
                this.getNoticeService().updateByPrimaryKey(list);
            }
        }

        return null;
    }

    private NoticeService getNoticeService() {
        return SpringContextHolder.getOneBean(NoticeService.class);
    }


}
