/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.command.IMsgCommand;
import com.els.base.notice.command.ImInvoker;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;
import java.util.List;

public class BatchCancelCommand
implements IMsgCommand<String> {
    private List<String> noticeIdList;

    public BatchCancelCommand(List<String> noticeIdList) {
        this.noticeIdList = noticeIdList;
    }

    @Override
    public String execute(ImInvoker invoker) {
        Assert.isNotEmpty(this.noticeIdList, (String)"\u64a4\u9500\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        NoticeExample noticeExample = new NoticeExample();
        noticeExample.createCriteria().andIdIn((List)this.noticeIdList);
        List<Notice> noticeLists = this.getNoticeService().queryAllObjByAllExample(noticeExample);
        for (Notice list : noticeLists) {
            if (list.getStatus().equals(Constant.NO_INT)) {
                throw new CommonException("\u672a\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u4f5c\u5e9f");
            }
            list.setStatus(Constant.NO_INT);
            list.setPublishUserId(null);
            list.setPublishUserName(null);
            this.getNoticeService().updateByPrimaryKey(list);
        }
        return null;
    }

    private NoticeService getNoticeService() {
        return (NoticeService)SpringContextHolder.getOneBean(NoticeService.class);
    }
}

