package com.els.base.msg.mail.utils;

import java.io.UnsupportedEncodingException;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.utils.encryption.DESUtils;

/**
 * SendMailUtil 发送邮件类
 * 
 * @date 2017年9月25日 下午2:56:44
 * @version 1.0
 */
public class SendMailUtil {

    /**
     * 
     * @param mailPostInfo:邮件端口信息对象
     * @param receiveEmail:收件地址
     * @param subject:邮件主题
     * @param sendUser:发件人
     * @param receiveUser:收件人
     * @param mailContent:邮件内容
     * @throws Exception 
     */
    public static void sendMail(MailAccount senderMailAccount, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws Exception  {
    	String smtpHost = senderMailAccount.getStmpServerHost();
    	Integer smtpPort = senderMailAccount.getStmpServerPort();
		boolean isSSL = Constant.YES_INT.equals(senderMailAccount.getStmpServerIsSsl());
		
		String senderMailAddress = senderMailAccount.getMailAddress();
		
		String password = senderMailAccount.getPassword();
		password = DESUtils.decrypt(password, Constant.SECRET_KEY);
		
		String senderName = senderMailAccount.getUserName();
		
		sendMail(smtpHost, smtpPort , isSSL, senderMailAddress , password, senderName, receiveEmailAddress, receiveName, subject, mailContent);
    }
    
    public static void sendMail(
			String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress, String password,
			String senderName, String receiveEmailAddress, String receiveName, 
			String subject, String mailContent) throws MessagingException, UnsupportedEncodingException {
    	
    	Assert.isNotBlank(senderMailAddress, "发送的邮箱地址不能为空");
    	Assert.isNotBlank(senderName, "发件人名称不能为空");
    	Assert.isNotBlank(password, "密码不能为空");
    	Assert.isNotBlank(receiveEmailAddress, "收件的邮箱地址不能为空");
    	Assert.isNotBlank(receiveName, "收件人名称不能为空");
        Assert.isNotBlank(smtpHost, "STMP服务器地址 不能为空");
        Assert.isNotNull(smtpPort, "STMP服务器端口 不能为空");
        Assert.isNotBlank(subject, "邮件标题 不能为空");
        Assert.isNotBlank(mailContent, "邮件内容不能为空");
    	
    	// 配置发送邮件的环境属性
    	final Properties props = new Properties();
    	// 表示SMTP发送邮件，需要进行身份验证
    	props.put("mail.smtp.auth", "true");
    	// SMTP服务器地址
    	props.put("mail.smtp.host", smtpHost);
    	// SMTP服务器端口
    	if (isSSL) {
    		// 如果使用ssl，则去掉使用25端口的配置，进行如下配置
    		props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
    		props.put("mail.smtp.socketFactory.port", smtpPort);
    		props.put("mail.smtp.port", smtpPort);
    	} else {
    		props.put("mail.smtp.port", smtpPort);
    	}
    	// 发件人的账号
    	props.put("mail.user", senderMailAddress);
    	// 访问SMTP服务时需要提供的密码(邮箱密码)
    	props.put("mail.password", password);
    	// 构建授权信息，用于进行SMTP进行身份验证
    	Authenticator authenticator = new Authenticator() {
    		protected PasswordAuthentication getPasswordAuthentication() {
    			// 用户名、密码
    			String userName = props.getProperty("mail.user");
    			String password = props.getProperty("mail.password");
    			return new PasswordAuthentication(userName, password);
    		}
    	};
    	
    	// 使用环境属性和授权信息，创建邮件会话
    	Session mailSession = Session.getInstance(props, authenticator);
    	// 设置发件人
    	InternetAddress form = new InternetAddress(senderMailAddress, senderName,"UTF-8");
    	// 设置收件人
    	InternetAddress to = new InternetAddress(receiveEmailAddress,receiveName,"UTF-8");
    	
    	// 创建邮件消息
    	MimeMessage message = new MimeMessage(mailSession);
    	message.setFrom(form);
    	message.setRecipient(MimeMessage.RecipientType.TO, to);
    	
    	// 设置邮件标题
    	message.setSubject(subject);
    	// 设置邮件的内容体
    	message.setContent(mailContent, "text/html;charset=UTF-8");
    	// 发送邮件
//    	Transport.send(message);
    	 Transport transport = mailSession.getTransport();  
         // 连接邮件服务器  
         transport.connect(senderMailAddress, password);  
         // 发送邮件  
         transport.sendMessage(message, new Address[] {to});  
         // 关闭连接  
         transport.close();  
    	
    }
}
