package com.els.base.notice.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.utils.Assert;
import com.els.base.notice.dao.NoticeReceiverMapper;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultNoticeReceiverService")
public class NoticeReceiverServiceImpl implements NoticeReceiverService {
    @Resource
    protected NoticeReceiverMapper noticeReceiverMapper;

    @CacheEvict(value={"noticeReceiver"}, allEntries=true)
    @Override
    public void addObj(String noticeId, String receiverCompanyId) {
    	NoticeReceiver t = new NoticeReceiver();
    	t.setNoticeId(noticeId);
    	t.setReceiverCompanyId(receiverCompanyId);
        this.noticeReceiverMapper.insertSelective(t);
    }

    @CacheEvict(value={"noticeReceiver"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.noticeReceiverMapper.deleteByPrimaryKey(id);
    }

    @Cacheable(value="noticeReceiver", keyGenerator="redisKeyGenerator")
    @Override
    public NoticeReceiver queryObjById(String id) {
        return this.noticeReceiverMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="noticeReceiver", keyGenerator="redisKeyGenerator")
    @Override
    public List<NoticeReceiver> queryAllObjByExample(NoticeReceiverExample example) {
        return this.noticeReceiverMapper.selectByExample(example);
    }

    @Cacheable(value="noticeReceiver", keyGenerator="redisKeyGenerator")
	@Override
	public void deleteByExample(NoticeReceiverExample example) {
		this.noticeReceiverMapper.deleteByExample(example);
	}

    @Cacheable(value="noticeReceiver", keyGenerator="redisKeyGenerator")
	@Override
	public void addAll(String noticeId, List<String> receiverIdList) {
		Assert.isNotBlank(noticeId, "noticeId 不能为空");
		Assert.isNotEmpty(receiverIdList, "receiverCompanyIdList 不能为空");
		
		List<NoticeReceiver> list = new ArrayList<>(receiverIdList.size());
		for(String receiverId : receiverIdList){
			NoticeReceiver receiver = new NoticeReceiver();
			receiver.setNoticeId(noticeId);
			receiver.setReceiverCompanyId(receiverId);
			receiver.setId(UUIDGenerator.generateUUID());
			list.add(receiver);
		}
		this.noticeReceiverMapper.insertBatch(list);
	}

	@Override
	public List<NoticeReceiver> queryObjByNoticeId(String noticeId) {
		NoticeReceiverExample noticeReceiverExample = new NoticeReceiverExample();
		noticeReceiverExample.createCriteria().andNoticeIdEqualTo(noticeId);
		noticeReceiverExample.setOrderByClause("RECEIVER_COMPANY_ID ASC");
		return this.queryAllObjByExample(noticeReceiverExample);
	}
}