package com.els.base.msg.mail.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailAccountExample;
import com.els.base.msg.mail.service.MailAccountService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="消息管理-邮件-帐号信息")
@Controller
@RequestMapping("mailAccout")
public class MailAccountController {
    @Resource
    protected MailAccountService mailAccountService;
    
    @ApiOperation(httpMethod="POST", value="预创建邮件信息")
    @RequestMapping("service/createPreveiw")
    @ResponseBody
    public ResponseResult<MailAccount> createPreveiw() {
    	MailAccount mailAccount = new MailAccount();
    	mailAccount.setProjectId(ProjectUtils.getProjectId());
//        mailAccount.setCompanyId(CompanyUtils.currentCompanyId());
//        mailAccount.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        mailAccount.setUserId(SpringSecurityUtils.getLoginUserId());
        mailAccount.setUserLoginName(SpringSecurityUtils.getLoginUserName());
        mailAccount.setUserName(SpringSecurityUtils.getLoginUser().getNickName());
        mailAccount.setMailAddress(SpringSecurityUtils.getLoginUser().getEmail());
        mailAccount.setStmpServerPort(25);
        mailAccount.setStmpServerIsSsl(Constant.NO_INT);
        
    	return ResponseResult.success(mailAccount);
    }
    
    @ApiOperation(httpMethod="POST", value="创建邮件信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody(required=true) MailAccount mailAccount) {
    	if (mailAccount.getMailAddress() != null && mailAccount.getMailAddress().length() > 255
                || mailAccount.getStmpServerHost() != null && mailAccount.getStmpServerHost().length() > 255
                || mailAccount.getRemark() != null && mailAccount.getRemark().getBytes().length > 255 
                || mailAccount.getPassword() != null && mailAccount.getPassword().length() > 255) {
            throw new CommonException("输入的参数长度超标", "database_length_error");
        }
    	
        mailAccount.setProjectId(ProjectUtils.getProjectId());
//        mailAccount.setCompanyId(CompanyUtils.currentCompanyId());
//        mailAccount.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        
        mailAccount.setCreateUser(SpringSecurityUtils.getLoginUserName());
        
        this.mailAccountService.addObj(mailAccount);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑邮件信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MailAccount mailAccount) {
        if (StringUtils.isBlank(mailAccount.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        
        if (mailAccount.getMailAddress() != null && mailAccount.getMailAddress().length() > 255
                || mailAccount.getStmpServerHost() != null && mailAccount.getStmpServerHost().length() > 255
                || mailAccount.getRemark() != null && mailAccount.getRemark().getBytes().length > 255 
                || mailAccount.getPassword() != null && mailAccount.getPassword().length() > 255) {
            throw new CommonException("输入的参数长度超标", "database_length_error");
        }
        
        this.mailAccountService.modifyObj(mailAccount);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除邮件信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.mailAccountService.deleteObjById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="设置该邮箱帐号为默认")
    @RequestMapping("service/setDefalut")
    @ResponseBody
    public ResponseResult<String> setDefalut(@RequestParam(required=true) String id) {
    	if (StringUtils.isBlank(id)) {
    		throw new CommonException("id不能为空");
    	}
//    	this.mailAccountService.setMailAccountAsDefault(CompanyUtils.currentCompanyId(), id);
    	this.mailAccountService.setMailAccountAsDefault(null, id);
    	return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询邮件信息")
    @ApiImplicitParams({ 
        @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
	    @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
	    @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 MailAccount", paramType = "body", dataType = "QueryParamWapper" )  
    }) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<MailAccount>> findByPage(
    		@RequestParam(defaultValue="0") int pageNo,
    		@RequestParam(defaultValue="10") int pageSize,
    		@RequestBody(required=false) QueryParamWapper wapper) {
    	
        MailAccountExample example = new MailAccountExample();
        example.setPageView(new PageView<MailAccount>(pageNo, pageSize));
        
        MailAccountExample.Criteria criteria = example.createCriteria();
//        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView<MailAccount> pageData = this.mailAccountService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
}