package com.els.base.msg.common.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.Message;
import com.els.base.msg.common.dao.MsgConfigMapper;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.msg.im.ImMessageCommand;
import com.els.base.msg.mail.MailMessageCommand;
import com.els.base.msg.weixin.WeixinMessageCommand;

@Service("defaultMsgConfigService")
public class MsgConfigServiceImpl implements MsgConfigService {
    @Resource
    protected MsgConfigMapper msgConfigMapper;

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    @Override
    public void addObj(MsgConfig msgConfig){
    	Assert.isNotBlank(msgConfig.getBusinessType(), "业务类型不能为空");
    	
    	MsgConfigExample example = new MsgConfigExample();
    	example.createCriteria().andBusinessTypeEqualTo(msgConfig.getBusinessType());
    	
    	if (this.msgConfigMapper.countByExample(example) > 0) {
			throw new CommonException("该业务类型已经配置规则，无法重复添加");
		}
    	
    	if (msgConfig.getIsEnable() == null || 
    			!Constant.NO_INT.equals(msgConfig.getIsEnable())) {
    		msgConfig.setIsEnable(Constant.YES_INT);
    	}
    	
    	if (msgConfig.getSysMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getSysMsg())) {
			msgConfig.setSysMsg(Constant.NO_INT);
		}
    	
    	if (msgConfig.getWeixinMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getWeixinMsg())) {
    		msgConfig.setWeixinMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getMailMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getMailMsg()) ) {
    		msgConfig.setMailMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getSmsMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getSmsMsg())) {
    		msgConfig.setSmsMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getAppMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getAppMsg())) {
    		msgConfig.setAppMsg(Constant.NO_INT);
    	}
    	
    	msgConfig.setUpdateTime(new Date());
        this.msgConfigMapper.insertSelective(msgConfig);
    }

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.msgConfigMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    @Override
    public void modifyObj(MsgConfig msgConfig){
    	Assert.isNotBlank(msgConfig.getId(), "id 为空，无法更新");
    	
    	if (StringUtils.isNotBlank(msgConfig.getBusinessType())) {
    		MsgConfigExample example = new MsgConfigExample();
    		example.createCriteria().andBusinessTypeEqualTo(msgConfig.getBusinessType()).andIdNotEqualTo(msgConfig.getId());
    		
    		if (this.msgConfigMapper.countByExample(example) > 0) {
    			throw new CommonException("该业务类型已经配置规则，无法重复添加");
    		}
		}
    	
    	if (msgConfig.getSysMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getSysMsg())) {
			msgConfig.setSysMsg(Constant.NO_INT);
		}
    	
    	if (msgConfig.getWeixinMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getWeixinMsg())) {
    		msgConfig.setWeixinMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getMailMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getMailMsg()) ) {
    		msgConfig.setMailMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getSmsMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getSmsMsg())) {
    		msgConfig.setSmsMsg(Constant.NO_INT);
    	}
    	
    	if (msgConfig.getAppMsg() == null || 
    			!Constant.YES_INT.equals(msgConfig.getAppMsg())) {
    		msgConfig.setAppMsg(Constant.NO_INT);
    	}
    	
    	msgConfig.setUpdateTime(new Date());
        this.msgConfigMapper.updateByPrimaryKeySelective(msgConfig);
    }

    @Cacheable(value="msgConfig", keyGenerator="redisKeyGenerator")
    @Override
    public MsgConfig queryObjById(String id) {
        return this.msgConfigMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="msgConfig", keyGenerator="redisKeyGenerator")
    @Override
    public List<MsgConfig> queryAllObjByExample(MsgConfigExample example) {
        return this.msgConfigMapper.selectByExample(example);
    }

    @Cacheable(value="msgConfig", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<MsgConfig> queryObjByPage(MsgConfigExample example) {
        PageView<MsgConfig> pageView = example.getPageView();
        pageView.setQueryResult(this.msgConfigMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="msgConfig", keyGenerator="redisKeyGenerator")
	@Override
	public List<IMessageCommand> querySender(Message<?> message) {
    	
    	MsgConfigExample example = new MsgConfigExample();
    	example.createCriteria().andBusinessTypeEqualTo(message.getBusinessTypeCode()).andIsEnableEqualTo(Constant.YES_INT);
    	List<MsgConfig> list = this.msgConfigMapper.selectByExample(example);
    	
    	if (CollectionUtils.isEmpty(list)) {
			return null;
		}
    	
    	ImMessageCommand imCommand = new ImMessageCommand();
    	MailMessageCommand mailCommand = new MailMessageCommand();
    	WeixinMessageCommand weixinCommand = new WeixinMessageCommand();
    	
    	List<IMessageCommand> commandList = new ArrayList<>();
    	for(MsgConfig config : list){
    		if (Constant.YES_INT.equals(config.getSysMsg()) && !commandList.contains(imCommand)) {
				commandList.add(imCommand);
			}
    		if (Constant.YES_INT.equals(config.getMailMsg()) && !commandList.contains(mailCommand)) {
    			commandList.add(mailCommand);
    		}
    		if (Constant.YES_INT.equals(config.getWeixinMsg()) && !commandList.contains(weixinCommand)) {
    			commandList.add(weixinCommand);
    		}
    	}
		
		return commandList;
	}

	@CacheEvict(value={"msgConfig"}, allEntries=true)
	@Override
	public void disableMsgConfig(List<String> ids, int isEnable) {
		Assert.isNotEmpty(ids, "发送配置id不能为空");
		
		MsgConfigExample example = new MsgConfigExample();
		example.createCriteria().andIdIn(ids);
		
		MsgConfig temp = new MsgConfig();
		temp.setIsEnable(Constant.YES_INT.equals(isEnable) ? Constant.YES_INT : Constant.NO_INT);
		this.msgConfigMapper.updateByExampleSelective(temp, example);
	}

	@CacheEvict(value={"msgConfig"}, allEntries=true)
	@Transactional
	@Override
	public void modifyObj(List<MsgConfig> msgConfigList) {
		if (CollectionUtils.isEmpty(msgConfigList)) {
			throw new CommonException("消息配置不能为空");
		}
		
		for(MsgConfig msgConfig : msgConfigList){
			
			msgConfig.setBusinessType(null);
			msgConfig.setIsEnable(null);
			this.modifyObj(msgConfig);
		}
	}
	
	@CacheEvict(value = { "msgConfig" }, allEntries = true)
	@Override
	public void deleteByExample(MsgConfigExample example) {
		Assert.isNotNull(example, "参数不能为空");
    	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
    	
    	this.msgConfigMapper.deleteByExample(example);		
	}

	@CacheEvict(value = { "msgConfig" }, allEntries = true)
	@Transactional
	@Override
	public void addAll(List<MsgConfig> list) {
		if (CollectionUtils.isEmpty(list)) {
			return;
		}
		
		list.forEach(record ->{
			this.msgConfigMapper.insertSelective(record);		
		});		
	}
}