package com.els.base.msg.common.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;
import com.els.base.msg.common.service.MsgConfigService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="消息发送配置")
@Controller
@RequestMapping("msgConfig")
public class MsgConfigController {
    @Resource
    protected MsgConfigService msgConfigService;

    @ApiOperation(httpMethod="POST", value="创建消息发送配置")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MsgConfig msgConfig) {
    	Assert.isNotBlank(msgConfig.getBusinessType(), "业务类型不能为空");
    	if (!msgConfig.getBusinessType().matches("[\\w\\_]+")) {
			throw new CommonException("业务类型的格式错误");
		}
    	
    	msgConfig.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
    	msgConfig.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.msgConfigService.addObj(msgConfig);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑消息发送配置")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<MsgConfig> msgConfigList) {
        if (CollectionUtils.isEmpty(msgConfigList)) {
            throw new CommonException("id 为空，保存失败");
        }
        
        for(MsgConfig msgConfig : msgConfigList){
        	if (!msgConfig.getBusinessType().matches("[\\w\\_]+")) {
    			throw new CommonException("业务类型的格式错误");
    		}
        	
        	msgConfig.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        	msgConfig.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        }
        
        this.msgConfigService.modifyObj(msgConfigList);
        
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="批量禁用消息发送配置")
    @RequestMapping("service/disableMsgConfig")
    @ResponseBody
    public ResponseResult<String> disableMsgConfig(@RequestBody(required=true) List<String> ids, int isEnable) {
    	Assert.isNotEmpty(ids, "参数不能为空");
    	
        this.msgConfigService.disableMsgConfig(ids, isEnable);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="删除消息发送配置")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.msgConfigService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询消息发送配置")
    @ApiImplicitParams({ 
	    @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
	    @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
	    @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 MsgConfig", paramType = "body", dataType = "QueryParamWapper" )  
    }) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<MsgConfig>> findByPage(
    		@RequestParam(defaultValue="0") int pageNo,
    		@RequestParam(defaultValue="10") int pageSize,
    		@RequestBody(required=false) QueryParamWapper wapper) {
    	
        MsgConfigExample example = new MsgConfigExample();
        example.setPageView(new PageView<MsgConfig>(pageNo, pageSize));
        
        if (wapper != null) {
            MsgConfigExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<MsgConfig> pageData = this.msgConfigService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}