package com.els.base.notice.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="公告通知表")
public class Notice implements Serializable {
    
	/************以下非自动生成***************/
	
	@ApiModelProperty("指定接收人")
	private List<NoticeReceiver> receiverIdList;
	
	public List<NoticeReceiver> getReceiverIdList() {
		return receiverIdList;
	}

	public void setReceiverIdList(List<NoticeReceiver> receiverIdList) {
		this.receiverIdList = receiverIdList;
	}


	
	
	@ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("内容")
    private String contents;

    @ApiModelProperty("类型（参考字典NOTICE_TYPE）")
    private String type;

    @ApiModelProperty("发布状态（0未发布，1已发布）")
    private Integer status;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("是否是发给所有人，0不是，1是")
    private Integer isAllReceived;
	
	@JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件")
    private String attachments;

    @ApiModelProperty("创建人id")
    private String createUserId;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("生效期开始时间")
    private Date validStartTime;

    @ApiModelProperty("生效期结束时间")
    private Date validEndTime;

    @ApiModelProperty("发布人id")
    private String publishUserId;

    @ApiModelProperty("发布人名称")
    private String publishUserName;

    @ApiModelProperty("公告编码")
    private String noticeNo;

    @ApiModelProperty("正文")
    private String content;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件")
    private String attachment;

    @ApiModelProperty("是否置顶")
    private Integer stick;

    public Integer getStick() {
        return stick;
    }

    public void setStick(Integer stick) {
        this.stick = stick;
    }

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getContents() {
        return contents;
    }

    public void setContents(String contents) {
        this.contents = contents == null ? null : contents.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsAllReceived() {
        return isAllReceived;
    }

    public void setIsAllReceived(Integer isAllReceived) {
        this.isAllReceived = isAllReceived;
    }

    public String getAttachments() {
        return attachments;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments == null ? null : attachments.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public Date getValidStartTime() {
        return validStartTime;
    }

    public void setValidStartTime(Date validStartTime) {
        this.validStartTime = validStartTime;
    }

    public Date getValidEndTime() {
        return validEndTime;
    }

    public void setValidEndTime(Date validEndTime) {
        this.validEndTime = validEndTime;
    }

    public String getPublishUserId() {
        return publishUserId;
    }

    public void setPublishUserId(String publishUserId) {
        this.publishUserId = publishUserId == null ? null : publishUserId.trim();
    }

    public String getPublishUserName() {
        return publishUserName;
    }

    public void setPublishUserName(String publishUserName) {
        this.publishUserName = publishUserName == null ? null : publishUserName.trim();
    }

    public String getNoticeNo() {
        return noticeNo;
    }

    public void setNoticeNo(String noticeNo) {
        this.noticeNo = noticeNo == null ? null : noticeNo.trim();
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }
}