/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.service.impl;

import com.els.base.core.utils.Assert;
import com.els.base.notice.dao.NoticeReceiverMapper;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultNoticeReceiverService")
public class NoticeReceiverServiceImpl
implements NoticeReceiverService {
    @Resource
    protected NoticeReceiverMapper noticeReceiverMapper;

    @Override
    @CacheEvict(value={"noticeReceiver"}, allEntries=true)
    public void addObj(String noticeId, String receiverCompanyId) {
        NoticeReceiver t = new NoticeReceiver();
        t.setNoticeId(noticeId);
        t.setReceiverCompanyId(receiverCompanyId);
        this.noticeReceiverMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"noticeReceiver"}, allEntries=true)
    public void deleteObjById(String id) {
        this.noticeReceiverMapper.deleteByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"noticeReceiver"}, keyGenerator="redisKeyGenerator")
    public NoticeReceiver queryObjById(String id) {
        return this.noticeReceiverMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"noticeReceiver"}, keyGenerator="redisKeyGenerator")
    public List<NoticeReceiver> queryAllObjByExample(NoticeReceiverExample example) {
        return this.noticeReceiverMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"noticeReceiver"}, keyGenerator="redisKeyGenerator")
    public void deleteByExample(NoticeReceiverExample example) {
        this.noticeReceiverMapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"noticeReceiver"}, keyGenerator="redisKeyGenerator")
    public void addAll(String noticeId, List<String> receiverIdList) {
        Assert.isNotBlank((String)noticeId, (String)"noticeId \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(receiverIdList, (String)"receiverCompanyIdList \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<NoticeReceiver> list = new ArrayList<NoticeReceiver>(receiverIdList.size());
        for (String receiverId : receiverIdList) {
            NoticeReceiver receiver = new NoticeReceiver();
            receiver.setNoticeId(noticeId);
            receiver.setReceiverCompanyId(receiverId);
            receiver.setId(UUIDGenerator.generateUUID());
            list.add(receiver);
        }
        this.noticeReceiverMapper.insertBatch(list);
    }

    @Override
    public List<NoticeReceiver> queryObjByNoticeId(String noticeId) {
        NoticeReceiverExample noticeReceiverExample = new NoticeReceiverExample();
        noticeReceiverExample.createCriteria().andNoticeIdEqualTo(noticeId);
        noticeReceiverExample.setOrderByClause("RECEIVER_COMPANY_ID ASC");
        return this.queryAllObjByExample(noticeReceiverExample);
    }
}

