/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.ResponseCode;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.im.util.MessageUtils;
import com.qqt.message.client.MessagePageVO;
import com.qqt.message.client.UserMessageExample;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.ConnectException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6d88\u606f\u7ba1\u7406-\u7cfb\u7edf\u6d88\u606f\u6d4b\u8bd5")
@Controller
@RequestMapping(value={"imMessage"})
public class ImMessageController {
    @ApiOperation(value="\u6d88\u606f\u53d1\u9001\u6d4b\u8bd5", httpMethod="POST")
    @RequestMapping(value={"front/sendTestMessage"})
    @ResponseBody
    public ResponseResult<String> sendTestMessage(String message, String sender, String receiver) {
        String title = "\u6d4b\u8bd5\u6807\u9898" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss");
        String companyCode = "test";
        try {
            MessageUtils.pushSystemMessage(title, message, receiver, companyCode, MessageLevelEnum.HIGH);
            return ResponseResult.success();
        }
        catch (ConnectException e) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)"\u8fde\u63a5\u6d88\u606f\u670d\u52a1\u5668\u8d85\u65f6");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u6d88\u606f", httpMethod="POST")
    @RequestMapping(value={"service/querySysMessage"})
    @ResponseBody
    public ResponseResult<MessagePageVO> querySysMessage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize) {
        UserMessageExample example = new UserMessageExample();
        example.andAccount(SpringSecurityUtils.getLoginUserId()).andTypeEq("system");
        HashMap<String, String> sorts = new HashMap<String, String>();
        sorts.put("createTime", "DESC");
        MessagePageVO listMessage = null;
        try {
            listMessage = MessageUtils.listMessage(pageNo, pageSize, example, sorts);
        }
        catch (ConnectException e) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseResult.success((Object)listMessage);
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u8bfb\u7cfb\u7edf\u6d88\u606f\u7684\u6570\u91cf", httpMethod="POST")
    @RequestMapping(value={"service/querySysMessageUnreadCount"})
    @ResponseBody
    public ResponseResult<Integer> querySysMessageUnreadCount() {
        UserMessageExample example = new UserMessageExample();
        example.andAccount(SpringSecurityUtils.getLoginUserId()).andTypeEq("system").andAccountUnread(SpringSecurityUtils.getLoginUserId());
        HashMap<String, String> sorts = new HashMap<String, String>();
        sorts.put("createTime", "DESC");
        try {
            MessagePageVO result = MessageUtils.listMessage(1, 1, example, sorts);
            return ResponseResult.success((Object)result.getTotal());
        }
        catch (ConnectException e) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.success((Object)0);
        }
    }

    @ApiOperation(value="\u6807\u8bb0\u6d88\u606f\u5df2\u8bfb", httpMethod="POST")
    @RequestMapping(value={"service/markAsRead"})
    @ResponseBody
    public ResponseResult<String> markAsRead(String msgId) {
        if (StringUtils.isBlank((String)msgId)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u6d88\u606f", "im_msg_id_is_null");
        }
        try {
            MessageUtils.markMsg2Read(msgId, SpringSecurityUtils.getLoginUserId());
            return ResponseResult.success();
        }
        catch (ConnectException e) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)"\u8fde\u63a5\u6d88\u606f\u670d\u52a1\u5668\u8d85\u65f6");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail);
        }
    }

    @ApiOperation(value="\u6807\u8bb0\u6d88\u606f\u5df2\u8bfb", httpMethod="POST")
    @RequestMapping(value={"service/markListAsRead"})
    @ResponseBody
    public ResponseResult<String> markAsRead(@RequestBody List<String> msgIdList) {
        if (CollectionUtils.isEmpty(msgIdList)) {
            throw new CommonException("\u8bf7\u9009\u62e9\u6d88\u606f", "im_msg_id_is_null");
        }
        try {
            for (String msgId : msgIdList) {
                MessageUtils.markMsg2Read(msgId, SpringSecurityUtils.getLoginUserId());
            }
            return ResponseResult.success();
        }
        catch (ConnectException e) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)"\u8fde\u63a5\u6d88\u606f\u670d\u52a1\u5668\u8d85\u65f6");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail);
        }
    }
}

