package com.els.base.msg.common.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.Message;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;

public interface MsgConfigService extends BaseService<MsgConfig, MsgConfigExample, String> {

	/**
	 * 根据消息，查询出对应的消息发送指令
	 * @param message
	 * @return
	 */
	List<IMessageCommand> querySender(Message<?> message);

	/**
	 * 禁用发送消息的配置
	 * @param ids
	 */
	void disableMsgConfig(List<String> ids, int isEnable);

	/**
	 * 批量修改发送消息配置
	 * @param msgConfigList
	 */
	void modifyObj(List<MsgConfig> msgConfigList);

	
	
	
}