package com.els.base.msg.mail.web.controller;

import java.text.MessageFormat;

import javax.annotation.Resource;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.RandomUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.utils.SmtpSendUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 邮箱验证码控制器
 * @author hzy
 *
 */
@Api("消息管理-邮箱-验证码")
@Controller
@RequestMapping("mailVerificationCode")
public class MailVerfiCodeController {
	
	@Resource
	protected MailAccountService mailAccountService;
	
	@ApiOperation("发送邮箱验证码")
	@RequestMapping("/front/sendCode")
	@ResponseBody
	public ResponseResult<String> sendCode(HttpSession session, String receiveEmailAddress, String receiveName) throws Exception{
		Assert.isNotBlank(receiveEmailAddress, "邮箱地址不能为空");
		
		//1、获取华阳的邮箱服务器配置
		MailAccount mailAccount = this.mailAccountService.queryDefaultMailAccoutByCompanyId(ProjectUtils.getProject().getCompanyId());
		Assert.isNotNull(mailAccount, "华阳的邮箱服务器还没有配置");
		
		//2、生成四位随机验证码
		int code = RandomUtils.nextInt(1000, 9999);
		session.setAttribute("mailVerifCode", String.valueOf(code));
		session.setAttribute("mailVerifAddress", receiveEmailAddress);
		
		//3、发送验证码到客户邮箱
		String mailContent = MessageFormat.format("您的邮箱验证码是：{0}", String.valueOf(code));
		SmtpSendUtils.sendMail(mailAccount, receiveEmailAddress, receiveName, "邮箱验证码", mailContent);
		
		return ResponseResult.success();
	}
	
}
