package com.els.base.msg.weixin.web.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.msg.weixin.WeixinMsgConstant;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.qrcode.service.WxQrcodeService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;

@Api(value = "消息管理-微信公众号二维码绑定")
@Controller
@RequestMapping("wxQrcode")
public class WxQrcodeController {
	
	@Resource
	private WxQrcodeService wxQrcodeService;
	
	@ApiOperation(httpMethod = "GET", value = "创建当前用户的公众号绑定二维码")
	@RequestMapping("service/createQrcodeForCurrentUser")
	@ResponseBody
	public ModelAndView createQrcodeForCurrentUser(HttpServletResponse response) throws WxErrorException, IOException{
		String userId = SpringSecurityUtils.getLoginUserId();
		WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(WxAccountConfigUtils.getDefaultAccountFromConfig());
		
		
		String sceneStr = WeixinMsgConstant.QRCODE_PREFIX_BIND_USER + userId;
		WxMpQrcodeService qrcodeService = wxMpService.getQrcodeService();
		WxMpQrCodeTicket ticket = qrcodeService.qrCodeCreateTmpTicket(sceneStr, 30 * 60);
		File file = qrcodeService.qrCodePicture(ticket);
		
		response.addHeader("Content-Disposition",  "inline;filename=\""+URLEncoder.encode("qrcode.jpg", "UTF-8") + "\";");
		response.setContentType("image/jpg");
		OutputStream outputStream = response.getOutputStream();
		
		byte[] tmp = new byte[1024];
		InputStream inputStream = new FileInputStream(file);
		while (inputStream .read(tmp) != -1) {
			outputStream.write(tmp);
		}

		outputStream.flush();
		outputStream.close();
		inputStream.close();
		
		return null;
	}

}
