package com.els.base.msg.weixin.web.controller;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.ResponseCode;
import com.els.base.wechat.common.WxConstant;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.oauth.web.controller.WechatOauthController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api("微信-会员资料")
@RequestMapping("wxMember")
@Controller("msgWxMemberController")
public class WxMemberController {

	@Autowired
	private WxMemberService wxMemberService;

	@Autowired
	private WechatOauthController wechatOauthController;
	
	@ApiOperation(value="检查当前用户是否有绑定",httpMethod = "GET")
	@RequestMapping("front/isTie")
	@ResponseBody
	public ResponseResult<String> isTie(@ApiParam(value="授权的页面") String url, HttpServletRequest request) throws Exception{
		
		String openid = (String) request.getSession().getAttribute(WxConstant.PARAMS_MAP_KEY_OPENID);
		if (StringUtils.isBlank(openid)) {
			return ResponseResult
					.fail(ResponseCode.Account_No_Login)
					.setMsg("微信帐号未跳转登录")
					.setData(wechatOauthController.createOauthUrlForOpenid(url, null, request).getData());
		}
		
		WxMember wxMemeber = this.wxMemberService.queryByOpenId(openid);
		if (wxMemeber == null) {
			throw new CommonException("微信帐号不存在，请关注公众号");
		}
		
		if (StringUtils.isBlank(wxMemeber.getMemberId())) {
			return ResponseResult
					.fail(ResponseCode.Account_Permission_denied)
					.setMsg("微信帐号未绑定");
		}
		
		User user = SpringSecurityUtils.getLoginUser();
		if (user == null) {
			return ResponseResult
					.fail(ResponseCode.Account_No_Login)
					.setMsg("微信帐号未跳转登录")
					.setData(wechatOauthController.createOauthUrlForOpenid(url, null, request).getData());
		}
		return ResponseResult.success();
	}
	
	@ApiOperation(value="用户解绑微信",httpMethod = "GET")
    @RequestMapping("front/untiedMemberId")
    @ResponseBody
    public ResponseResult<String>  untiedMemberId (@ApiParam(value="微信会员id") String id) {
		this.wxMemberService.unTieMemberId(id);

		return  ResponseResult.success();
	}

}
