package com.els.base.notice.command;

import java.util.List;

import com.els.base.core.exception.CommonException;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

public class DeleteCommand implements IMsgCommand<String> {

	private List<String> noticeId;

	public DeleteCommand(List<String> ids) {
		this.noticeId = ids;
	}

	@Override
	public String execute(ImInvoker invoker) {
		
		for(String id: this.noticeId){
			NoticeExample noticeExample = new NoticeExample();
			noticeExample.createCriteria().andIdIn(noticeId);
			List<Notice> noticeList = this.getNoticeService().queryAllObjByExample(noticeExample);
			for(Notice list : noticeList){
				if (list.getStatus().equals(1)) {
					throw new CommonException("已发布的公告不能删除");
				}else {
					this.getNoticeService().deleteObjById(id);
					NoticeReceiverExample example = new NoticeReceiverExample();
					example.createCriteria().andNoticeIdEqualTo(id);
					this.getNoticeReceiverService().deleteByExample(example);
				}
			}
		}
		
		return null;
	}

	private NoticeReceiverService getNoticeReceiverService() {
		return SpringContextHolder.getOneBean(NoticeReceiverService.class);
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}

}
