package com.els.base.msg.mail.service;

import com.els.base.core.service.BaseService;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailAccountExample;

public interface MailAccountService extends BaseService<MailAccount, MailAccountExample, String> {
	
	/**
	 * 根据用户id，查找该用户的邮箱帐号设置
	 * @param userId
	 * @return
	 */
	MailAccount queryByUserId(String userId);
	
	
	/**
	 * 根据企业id，查找该企业下默认的邮箱帐号设置
	 * @param companyId
	 * @return
	 */
	MailAccount queryDefaultMailAccoutByCompanyId(String companyId);
	
	/**
	 * 把该邮箱设置为企业的默认邮箱
	 * @param companyId
	 * @param mailAccountId
	 */
	void setMailAccountAsDefault(String companyId, String mailAccountId);
}