package com.els.base.notice.command;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

public class ModifyCommand implements IMsgCommand<String> {

	private Notice notice;
	private Notice originNotcie;

	public ModifyCommand(Notice notice) {
		this.notice = notice;
	}

	@Override
	public String execute(ImInvoker invoker) {
		//原来的公告
	    this.originNotcie = this.getNoticeService().queryObjById(this.notice.getId());
	    // 初始化数据
	    init(this.notice);
		// 数据校验
		valid(this.notice);
		// 修改数据
		modify(this.notice);
		return null;
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}

	private void modify(Notice notice) {
		this.getNoticeService().modifyObj(notice);
		
		if (Constant.NO_INT.equals(this.originNotcie.getIsAllReceived())
				&& Constant.YES_INT.equals(this.notice.getIsAllReceived())) {
			//原来不是全部发，现在改为全部发，就把指定的删除
			
			NoticeReceiverExample example = new NoticeReceiverExample();
			example.createCriteria().andNoticeIdEqualTo(notice.getId());
			
			this.getNoticeReceiverService().deleteByExample(example);
			return;
		}
		
		if (Constant.NO_INT.equals(this.originNotcie.getIsAllReceived())
				&& CollectionUtils.isNotEmpty(notice.getReceiverIdList())) {
			NoticeReceiverExample example = new NoticeReceiverExample();
			example.createCriteria().andNoticeIdEqualTo(notice.getId());
			
			this.getNoticeReceiverService().deleteByExample(example);
			
			List<String> companyIdList = new ArrayList<>();
			for(NoticeReceiver company : notice.getReceiverIdList()){
				companyIdList.add(company.getReceiverCompanyId());
			}
			this.getNoticeReceiverService().addAll(notice.getId(), companyIdList);
			return;
		}
		
	}

	private NoticeReceiverService getNoticeReceiverService() {
		return SpringContextHolder.getOneBean(NoticeReceiverService.class);
	}

	private void init(Notice notice2) {
		notice2.setCreateUserId(null);
		notice2.setCreateTime(null);
		notice2.setCreateUserName(null);
		notice2.setNoticeNo(null);
		
		List<NoticeReceiver> blankIds = new ArrayList<>();
		if (Constant.NO_INT.equals(notice.getIsAllReceived())
				&& CollectionUtils.isNotEmpty(notice.getReceiverIdList())) {
			//清空空的id
			for(NoticeReceiver receiverId: notice.getReceiverIdList()){
				if (StringUtils.isBlank(receiverId.getReceiverCompanyId())) blankIds.add(receiverId);
			}
			
			notice.getReceiverIdList().removeAll(blankIds);
		}
	}

	private void valid(Notice notice) {
		if (this.originNotcie == null) {
			throw new CommonException("该公告不存在");
		}
		
		if (notice.getValidStartTime()!= null 
				&& notice.getValidEndTime() != null
				&& notice.getValidStartTime().getTime() > notice.getValidEndTime().getTime()) {
			
			throw new CommonException("开始生效时间，不能大于结束时间");
		}
		
		if (Constant.YES_INT.equals(this.originNotcie.getIsAllReceived())
				&& Constant.NO_INT.equals(this.notice.getIsAllReceived())
				&& CollectionUtils.isEmpty(this.notice.getReceiverIdList())) {
			throw new CommonException("指定的接收方不能为空");
		}
		
	}

}
