package com.els.base.msg.mail.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.utils.encryption.DESUtils;

public class SmtpSendUtils {
	
	/**
     * 
     * @param mailPostInfo:邮件端口信息对象
     * @param receiveEmail:收件地址
     * @param subject:邮件主题
     * @param sendUser:发件人
     * @param receiveUser:收件人
     * @param mailContent:邮件内容
     * @throws Exception 
     */
    public static void sendMail(MailAccount senderMailAccount, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws Exception  {
    	String smtpHost = senderMailAccount.getStmpServerHost();
    	Integer smtpPort = senderMailAccount.getStmpServerPort();
		boolean isSSL = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
		
		String senderMailAddress = senderMailAccount.getMailAddress();
		
		String password = senderMailAccount.getPassword();
		password = DESUtils.decrypt(password, Constant.SECRET_KEY);
		
		String senderName = senderMailAccount.getUserName();
		
		sendMail(smtpHost, smtpPort , isSSL, senderMailAddress , password, senderName, receiveEmailAddress, receiveName, subject, mailContent, null);
    }
	
	public static void sendMail(String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress,
			String password, String senderName, String receiveEmailAddress, String receiveName, String subject,
			String mailContent, File attachment) throws MessagingException, UnsupportedEncodingException{
		
		Properties properties = new Properties();  
		
		properties.setProperty("mail.debug", "true");//启用调试  
		properties.setProperty("mail.smtp.timeout", "1000");//设置链接超时  
		properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));//设置端口  
		
		properties.setProperty("mail.smtp.socketFactory.fallback", "false");  
		
        if (isSSL) {
        	properties.setProperty("mail.smtp.auth", "true");//开启认证
        	properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));//设置ssl端口  
    		properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
		}
		
		JavaMailSenderImpl sender = new JavaMailSenderImpl();
		sender.setHost(smtpHost);
		sender.setPort(smtpPort);
		sender.setUsername(senderMailAddress);
		sender.setPassword(password);
		sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);  
		
		MimeMessage message = sender.createMimeMessage();

		MimeMessageHelper helper = new MimeMessageHelper(message, true);
		helper.setFrom(new InternetAddress(senderMailAddress, senderName,"UTF-8"));
		helper.setTo(new InternetAddress(receiveEmailAddress,receiveName,"UTF-8"));
		
		helper.setSubject(subject);
		helper.setText(mailContent, true);
		
		if (attachment != null) {
			helper.addAttachment(attachment.getName(), attachment);
		}
		sender.testConnection();
		sender.send(message);
	}
	
	/**
	 * 测试邮箱配置是否能联通
	 * @param senderMailAccount
	 * @throws Exception
	 */
	public static void testConnection(MailAccount senderMailAccount) throws Exception{
		String smtpHost = senderMailAccount.getStmpServerHost();
    	Integer smtpPort = senderMailAccount.getStmpServerPort();
		boolean isSSL = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
		
		String senderMailAddress = senderMailAccount.getMailAddress();
		
		String password = senderMailAccount.getPassword();
		password = DESUtils.decrypt(password, Constant.SECRET_KEY);
		
		testConnection(smtpHost, smtpPort, isSSL, senderMailAddress, password);
	}
	
	/**
	 * 测试邮箱配置是否能联通
	 * @param smtpHost
	 * @param smtpPort
	 * @param isSSL
	 * @param senderMailAddress
	 * @param password
	 * @throws MessagingException
	 */
	public static void testConnection(String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress, String password) throws MessagingException{
        Properties properties = new Properties();  
		
		properties.setProperty("mail.debug", "true");//启用调试  
		properties.setProperty("mail.smtp.timeout", "1000");//设置链接超时  
		properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));//设置端口  
		
		properties.setProperty("mail.smtp.socketFactory.fallback", "false");  
		
        if (isSSL) {
        	properties.setProperty("mail.smtp.auth", "true");//开启认证
        	properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));//设置ssl端口  
    		properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
		}
        
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
		sender.setHost(smtpHost);
		sender.setPort(smtpPort);
		sender.setUsername(senderMailAddress);
		sender.setPassword(password);
		sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);  
        
        sender.testConnection();
	}
	

}
