package com.els.base.msg;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.utils.SpringContextHolder;

/**
 * 消息发送工具
 * @author hzy
 *
 */
public abstract class MessageSendUtils {
	
	private static Logger logger = LoggerFactory.getLogger(MessageSendUtils.class);

	/**
	 * 发送消息
	 * @param senderId
	 * @param receiverId
	 * @param bussinessType
	 * @param data
	 */
	public static void sendMessage(Message<?> message){
		message.checkData();
		
		MsgConfigService msgConfigService = SpringContextHolder.getOneBean(MsgConfigService.class);
		List<IMessageCommand> senderList = msgConfigService.querySender(message);
		sendMessage(senderList, message);
	}
	
	private static void sendMessage(List<IMessageCommand> senderList, final Message<?> message) {
		if (CollectionUtils.isEmpty(senderList)) {
			return;
		}
		
		ThreadPoolTaskExecutor threadPool = SpringContextHolder.getOneBean(ThreadPoolTaskExecutor.class);
		for(int i=0; i<senderList.size(); i++){
			final IMessageCommand sender = senderList.get(i);
			threadPool.execute(new Runnable() {
				
				@Override
				public void run() {
					logger.info("执行消息命令:"+ sender.getClass());
					try {
						sender.sendMsg(message);
					} catch (Exception e) {
						logger.error("消息发送失败，发送器["+sender.getClass()+"]", e);
					}
				}
			});
		}
	}
	
	public static void main(String[] args) {
		Message<String> message = Message.init("abc")  //传入数据
				.setBusinessTypeCode("JIT_PLAN_SEND")  //业务编码
				.setCompanyCode("5000234")             //发送的企业srm编码
				.setMsgLevel(MessageLevelEnum.HIGH)     //消息等级
				.setSenderId(SpringSecurityUtils.getLoginUserId()) //发送人的userid
				
				.addReceiverId("123123") //添加单个收件人 userid
				.addReceiverIdList(new ArrayList<String>()); //添加多个收件人 userid
		
		MessageSendUtils.sendMessage(message);
	}
	
}
