package com.els.base.msg;

import java.util.List;

/**
 * 消息接口
 * @author hzy
 *
 * @param <T>
 */
public interface IMessage<T> {

	/**
	 * 消息的数据
	 * @return
	 */
	public T getData();

	/**
	 * 消息发送人
	 * @return
	 */
	public String getSenderId();

	/**
	 * 消息接受人
	 * @return
	 */
	public List<String> getReceiverIdList();

	/**
	 * 消息关联的业务类型
	 * @return
	 */
	public String getBusinessTypeCode();

	/**
	 * 消息的级别
	 * @return
	 */
	public MessageLevelEnum getMsgLevel();
	
	/**
	 * 发送者的企业code
	 * @return
	 */
	public String getCompanyCode();


}
