package com.els.base.msg.im.util;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.els.base.core.utils.Assert;

@Component
public class ImMessagePushProperties {

	@Value("${push.message.access.token:YTY2ODlkNjhkNDk1MThjZDpiOWYxMGZiMzNiMWNjOGYx}")
	private String accessToken;
	
	@Value("${push.message.host}")
	private String host;
	
	@Value("${push.message.port:80}")
	private Integer port;

	public String getAccessToken() {
		Assert.isNotBlank(host, "消息服务器accessToken不能为空");
		return accessToken;
	}

	public String getHost() {
		Assert.isNotBlank(host, "消息服务器host不能为空");
		return host;
	}

	public Integer getPort() {
		Assert.isNotBlank(host, "消息服务器port不能为空");
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}
	
	public String getAddUrl(){
		return String.format("http://%s:%s/message-manage-web/message/add", this.getHost(), this.getPort().toString());
	}
	
	public String getReadUrl(){
		return String.format("http://%s:%s/message-manage-web/message/read", this.getHost(), this.getPort().toString());
	}
	
	public String getReadMoreUrl(){
		return String.format("http://%s:%s/message-manage-web/message/read/more", this.getHost(), this.getPort().toString());
	}
	
	public String getListUrl(){
		return String.format("http://%s:%s/message-manage-web/message/list", this.getHost(), this.getPort().toString());
	}
	
	public String getCountUrl(){
		return String.format("http://%s:%s/message-manage-web/message/count", this.getHost(), this.getPort().toString());
	}
	
	public String getListAllUrl(){
		return String.format("http://%s:%s/message/message-manage-web/list/all", this.getHost(), this.getPort().toString());
	}

}
