package com.els.base.notice.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 门户命令执行器
 * @author hzy
 *
 */
@Component
public class ImInvoker {
	
	private static Logger logger = LoggerFactory.getLogger(ImInvoker.class);
	
	@Transactional
	public <T> T invoke(IMsgCommand<T> command){
		logger.debug("执行命令[{}]", command.getClass().getName());
		return command.execute(this);
	}

}
