package com.els.base.msg.im.web.controller;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.im.entity.ImTemplate;
import com.els.base.msg.im.entity.ImTemplateExample;
import com.els.base.msg.im.service.ImTemplateService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="im消息模板")
@Controller
@RequestMapping("imTemplate")
public class ImTemplateController {
    @Resource
    protected ImTemplateService imTemplateService;

    @ApiOperation(httpMethod="POST", value="创建im消息模板")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ImTemplate imTemplate) {
    	Assert.isNotNull(imTemplate, "参数不能为空");
        imTemplate.setProjectId(ProjectUtils.getProjectId());
//        imTemplate.setCompanyId(CompanyUtils.currentCompanyId());
        imTemplate.setCreateUser(SpringSecurityUtils.getLoginUser().getNickName());
    	this.imTemplateService.addObj(imTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑im消息模板")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ImTemplate imTemplate) {
        Assert.isNotBlank(imTemplate.getId(), "id 为空，保存失败");
        this.imTemplateService.modifyObj(imTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除im消息模板")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.imTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询im消息模板")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ImTemplate", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ImTemplate>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ImTemplateExample example = new ImTemplateExample();
        example.setPageView(new PageView<ImTemplate>(pageNo, pageSize));
        
        ImTemplateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<ImTemplate> pageData = this.imTemplateService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}