/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.controller.user;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ObjectUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u767b\u5f55\u5e10\u53f7\u7ba1\u7406")
@Controller
@RequestMapping(value={"user"})
public class UserController {
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5e10\u53f7\u8d44\u6599", httpMethod="GET")
    @RequestMapping(value={"service/queryUserDetail"})
    @ResponseBody
    public ResponseResult<User> queryUserDetail(@ApiParam(value="\u7528\u6237ID") String userId) {
        User user = (User)this.userService.queryObjById(userId);
        return ResponseResult.success((Object)user);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e10\u53f7", httpMethod="POST")
    @RequestMapping(value={"service/addUser"})
    @ResponseBody
    public ResponseResult<String> addUser(@RequestBody User user) {
        user.setId(null);
        user.setIsEnable(ObjectUtils.firstNotNull(user.getIsEnable(), Constant.YES_INT));
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        this.userService.addObj(user);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u6839\u636eid\u7981\u7528\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/disableUser"})
    @ResponseBody
    public ResponseResult<String> disableUser(@ApiParam(value="\u7528\u6237ID") String userId) {
        this.userService.disableUserById(userId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u5e10\u53f7\u4fe1\u606f(\u4e0d\u4fee\u6539\u5bc6\u7801)", httpMethod="POST")
    @RequestMapping(value={"service/modifyUser"})
    @ResponseBody
    public ResponseResult<String> modifyUser(@RequestBody User user, HttpSession session) {
        user.setPassword(null);
        this.userService.modifyObj(user);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<User>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        UserExample example = new UserExample();
        example.setPageView((PageView<User>)new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)example.createCriteria(), queryParams);
        }
        PageView list = this.userService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(value="\u68c0\u67e5\u65e7\u5bc6\u7801\u662f\u5426\u6b63\u786e,\u8fd4\u56de1\u6b63\u786e\uff0c0\u4e0d\u6b63\u786e", httpMethod="GET")
    @ResponseBody
    @RequestMapping(value={"service/checkOldPwd"})
    public ResponseResult<Integer> checkOldPwd(String userId, String oldPwd) {
        int result = this.userService.checkPassword(userId, oldPwd) ? 1 : 0;
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(value="\u5bc6\u7801\u91cd\u8bbe\u4e3a123456", httpMethod="GET")
    @ResponseBody
    @RequestMapping(value={"service/resetPwd"})
    public ResponseResult<String> resetPwd(@ApiParam(value="\u7528\u6237ID") @RequestParam(required=true) String userId) throws Exception {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("\u7528\u6237ID\u4e3a\u7a7a", "isNull", new Object[]{"\u7528\u6237ID"});
        }
        this.userService.resetPwd("123456", userId);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\uff0c\u67e5\u8be2\u8d26\u6237", httpMethod="GET")
    @RequestMapping(value={"service/queryUserByLoginName"})
    @ResponseBody
    public ResponseResult<User> queryUserByLoginName(String loginName) {
        return ResponseResult.success((Object)this.userService.findByUserLoginName(loginName));
    }
}

