/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.interceptor;

import com.els.base.core.entity.project.Project;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.project.ProjectUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ProjectInitInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(ProjectInitInterceptor.class);
    @Resource
    protected ProjectService projectService;
    @Value(value="${project.interceptor.enable:true}")
    protected String isProjectEnable;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri;
        if (!"true".equals(this.isProjectEnable)) {
            return super.preHandle(request, response, handler);
        }
        Project project = null;
        String projectId = null;
        try {
            projectId = (String)request.getSession().getAttribute("projectId");
            project = (Project)request.getSession().getAttribute("project");
        }
        catch (Exception e) {
            this.logger.error("projectId \u68c0\u67e5\u5f02\u5e38\uff1a", (Throwable)e);
            request.getSession().removeAttribute("projectId");
            request.getSession().removeAttribute("project");
        }
        if (projectId != null) {
            if (project == null) {
                project = (Project)this.projectService.queryObjById(projectId);
                request.getSession().setAttribute("project", (Object)project);
            }
            ProjectUtils.setInThreadLocal(project);
            return super.preHandle(request, response, handler);
        }
        String serverName = request.getServerName();
        project = this.projectService.queryByRequest(serverName, requestUri = request.getRequestURI());
        if (project == null) {
            this.logger.warn("projectId \u4e3a\u7a7a\uff0c\u6839\u636e\u57df\u540d\u68c0\u67e5\u4e0d\u5230project\uff1a[{0}]", (Object)serverName);
        } else {
            this.logger.debug("\u6839\u636e\u57df\u540d\u68c0\u67e5\u6210\u529f [" + project.getId() + "], projectName :[" + project.getProjectName() + "],sessionid" + request.getSession().getId());
        }
        if (project != null) {
            request.getSession().setAttribute("projectId", (Object)project.getId());
            request.getSession().setAttribute("project", (Object)project);
            ProjectUtils.setInThreadLocal(project);
        }
        return super.preHandle(request, response, handler);
    }
}

