/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.option.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.option.dao.OptionMapper;
import com.els.base.option.entity.Option;
import com.els.base.option.entity.OptionExample;
import com.els.base.option.service.OptionService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOptionService")
public class OptionServiceImpl
implements OptionService {
    @Resource
    protected OptionMapper optionMapper;

    @Override
    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public List<Option> selectByExampleWithBLOBs(OptionExample example) {
        return this.optionMapper.selectByExampleWithBLOBs(example);
    }

    @Override
    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public int countByExample(OptionExample example) {
        return this.optionMapper.countByExample(example);
    }

    @CacheEvict(value={"option"}, allEntries=true)
    public void addObj(Option t) {
        this.optionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"option"}, allEntries=true)
    public void addAll(List<Option> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.optionMapper.insertBatch(list);
    }

    @CacheEvict(value={"option"}, allEntries=true)
    public void deleteObjById(String id) {
        this.optionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"option"}, allEntries=true)
    public void deleteByExample(OptionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.optionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"option"}, allEntries=true)
    public void modifyObj(Option t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.optionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public Option queryObjById(String id) {
        return this.optionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public List<Option> queryAllObjByExample(OptionExample example) {
        return this.optionMapper.selectByExample(example);
    }

    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public PageView<Option> queryObjByPage(OptionExample example) {
        PageView<Option> pageView = example.getPageView();
        pageView.setQueryResult(this.optionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"option"}, keyGenerator="redisKeyGenerator")
    public PageView<Option> queryObjWithBLOBsByPage(OptionExample example) {
        PageView<Option> pageView = example.getPageView();
        pageView.setQueryResult(this.optionMapper.selectByExampleWithBLOBsByPage(example));
        return pageView;
    }
}

