/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.service.user.impl;

import com.els.base.core.dao.user.UserMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.event.user.UserCreatedEvent;
import com.els.base.core.exception.CommonException;
import com.els.base.core.listener.UserListener;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.encryption.DESUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
public class UserServiceImpl
implements UserService {
    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile(".*\\d.*");
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile(".*[A-Z].*");
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z].*");
    private static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile(".*\\W.*");
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private Optional<List<UserListener>> userListeners;

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public int updateByPrimaryKeySelective(User record) {
        return this.userMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void addUser(List<User> usersList) throws Exception {
        for (User user : usersList) {
            this.addObj(user, false);
        }
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void modifyPwd(String userId, String oldPwd, String newPwd) throws Exception {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38\uff0c\u7528\u6237id\u4e0d\u4e3a\u7a7a", "base_param_error", new Object[]{"\u7528\u6237id\u4e0d\u4e3a\u7a7a"});
        }
        if (StringUtils.isBlank((String)oldPwd)) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38\uff0c\u65e7\u5bc6\u7801\u4e0d\u4e3a\u7a7a", "base_param_error", new Object[]{"\u65e7\u5bc6\u7801\u4e0d\u4e3a\u7a7a"});
        }
        if (StringUtils.isBlank((String)newPwd)) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38\uff0c\u65b0\u5bc6\u7801\u4e0d\u4e3a\u7a7a", "base_param_error", new Object[]{"\u65b0\u5bc6\u7801\u4e0d\u4e3a\u7a7a"});
        }
        if (!this.checkPassword(userId, oldPwd)) {
            throw new CommonException("\u5bc6\u7801\u9519\u8bef", "base_account_password_worn");
        }
        this.updatePwd(newPwd, userId);
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public List<User> queryAllUserIsDisabled() {
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIsEnableEqualTo(Constant.NO_INT);
        return this.userMapper.selectByExample(userExample);
    }

    @CacheEvict(value={"userService"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id \u4e0d\u80fd\u5c11\u4e8e\u7b49\u4e8e0");
        }
        if ("1".equals(id.trim())) {
            throw new CommonException("\u7ba1\u7406\u5458,\u4e0d\u5141\u8bb8\u64cd\u4f5c", "admin_not_allow_oper");
        }
        this.userMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userService"}, allEntries=true)
    public void modifyObj(User user) {
        if (user == null || user.getId() == null) {
            throw new CommonException("id \u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isNotBlank((String)user.getLoginName())) {
            user.setLoginName(user.getLoginName().toLowerCase());
            if (!user.getLoginName().matches("^\\w([\\w\\-]){4,254}")) {
                throw new CommonException("\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002", "invaild_format", new Object[]{"\u8d26\u53f7", "\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002"});
            }
            if (user.getLoginName().length() > 255) {
                throw new CommonException("\u7528\u6237\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7528\u6237\u8d26\u53f7\u540d\u79f0", 255});
            }
            UserExample loginNameExample = new UserExample();
            loginNameExample.createCriteria().andLoginNameEqualTo(user.getLoginName().toLowerCase()).andIdNotEqualTo(user.getId());
            if (this.userMapper.countByExample(loginNameExample) > 0) {
                throw new CommonException("\u8d26\u53f7\u540d\u79f0\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"\u8d26\u53f7"});
            }
        }
        if (StringUtils.isNotBlank((String)user.getMobilePhone())) {
            if (user.getMobilePhone().length() > 11) {
                throw new CommonException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7528\u6237\u624b\u673a\u53f7", 11});
            }
            UserExample mobilePhoneExample = new UserExample();
            mobilePhoneExample.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone()).andIdNotEqualTo(user.getId());
            if (this.userMapper.countByExample(mobilePhoneExample) > 0) {
                throw new CommonException("\u624b\u673a\u53f7\u5df2\u5b58\u5728", "base_the_same_mobile");
            }
        }
        if (StringUtils.isNotBlank((String)user.getEmail())) {
            if (user.getEmail().length() > 255) {
                throw new CommonException("\u7528\u6237\u90ae\u7bb1\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7528\u6237\u90ae\u7bb1\u53f7", 255});
            }
            UserExample emailExample = new UserExample();
            emailExample.createCriteria().andEmailEqualTo(user.getEmail().toLowerCase()).andIdNotEqualTo(user.getId());
            if (this.userMapper.countByExample(emailExample) > 0) {
                throw new CommonException("Email\u5df2\u5b58\u5728", "base_the_same_email");
            }
        }
        if (user.getNickName() != null && user.getNickName().length() > 255) {
            throw new CommonException("\u6635\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u6635\u79f0", "255"});
        }
        Date date = new Date();
        user.setUpdateTime(date);
        this.userMapper.updateByPrimaryKeySelective(user);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void updatePwd(String password, String userId) throws Exception {
        String passwordKey = StringUtils.leftPad((String)String.valueOf(RandomUtils.nextInt((int)1000000)), (int)6, (String)"0");
        String enPassword = DESUtils.encrypt((String)(DESUtils.encrypt((String)password, (String)"tissonco") + passwordKey), (String)"tissonco");
        Date date = new Date();
        User tmp = new User();
        tmp.setId(userId);
        tmp.setPassword(enPassword);
        tmp.setPasswordKey(passwordKey);
        tmp.setPasswordStrength(this.resolvePasswordStrength(password));
        tmp.setExpireTime(date);
        this.userMapper.updateByPrimaryKeySelective(tmp);
    }

    private String resolvePasswordStrength(String password) {
        int strength = 0;
        if (NUMBER_PATTERN.matcher(password).find()) {
            ++strength;
        }
        if (UPPERCASE_PATTERN.matcher(password).find()) {
            ++strength;
        }
        if (LOWERCASE_PATTERN.matcher(password).find()) {
            ++strength;
        }
        if (SPECIAL_CHAR_PATTERN.matcher(password).find()) {
            ++strength;
        }
        return Integer.toString(strength);
    }

    @Override
    public void updateMobilePhone(String userId, String mobilePhone) {
        User updateVO = new User();
        updateVO.setId(userId);
        updateVO.setMobilePhone(mobilePhone);
        this.userMapper.updateByPrimaryKeySelective(updateVO);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void resetPwd(String password, String userId) throws Exception {
        String passwordKey = StringUtils.leftPad((String)String.valueOf(RandomUtils.nextInt((int)1000000)), (int)6, (String)"0");
        String enPassword = DESUtils.encrypt((String)(DESUtils.encrypt((String)password, (String)"tissonco") + passwordKey), (String)"tissonco");
        User tmp = new User();
        tmp.setId(userId);
        tmp.setPassword(enPassword);
        tmp.setPasswordKey(passwordKey);
        tmp.setExpireTime(null);
        this.userMapper.updateByPrimaryKeySelective(tmp);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public boolean checkPassword(String userId, String oldPwd) {
        if (StringUtils.isBlank((String)userId) || StringUtils.isBlank((String)oldPwd)) {
            return false;
        }
        User user = this.userMapper.selectByPrimaryKey(userId);
        try {
            String enPassword = null;
            String salt = user.getPasswordKey();
            enPassword = StringUtils.isNotBlank((String)salt) ? DESUtils.encrypt((String)(DESUtils.encrypt((String)oldPwd, (String)"tissonco") + salt), (String)"tissonco") : DESUtils.encrypt((String)oldPwd, (String)"tissonco");
            return enPassword.equals(user.getPassword());
        }
        catch (Exception e) {
            logger.error("\u5bc6\u7801\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void disableUserById(String userId) {
        User user = this.userMapper.selectByPrimaryKey(userId);
        if (user == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u7528\u6237", "user_not_found");
        }
        User tmp = new User();
        tmp.setId(user.getId());
        Integer isEnable = user.getIsEnable();
        if (Constant.YES_INT.equals(isEnable)) {
            tmp.setIsEnable(Constant.NO_INT);
        } else {
            tmp.setIsEnable(Constant.YES_INT);
        }
        this.userMapper.updateByPrimaryKeySelective(tmp);
    }

    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public User queryObjById(String id) {
        return this.userMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public User findByUserLoginName(String params) {
        Assert.isNotBlank((String)params, (String)"\u767b\u5f55\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        UserExample userExample = new UserExample();
        userExample.createCriteria().andLoginNameEqualTo(params.toLowerCase());
        userExample.or().andLoginNameEqualTo(params.toUpperCase());
        List<User> list = this.userMapper.selectByExample(userExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void disableMembers(String userId, Integer status) {
        User user = new User();
        user.setId(userId);
        user.setIsEnable(status);
        this.userMapper.updateByPrimaryKeySelective(user);
    }

    @CacheEvict(value={"userService"}, allEntries=true)
    @Transactional
    public void addObj(User user) {
        this.addObj(user, true);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    @Transactional
    public void addObj(User user, Boolean isPublishEvent) {
        Assert.isNotBlank((String)user.getPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)user.getProjectCode(), (String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)user.getLoginName(), (String)"\u767b\u5f55\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)user.getNickName(), (String)"\u5e10\u53f7\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        user.setLoginName(user.getLoginName().toLowerCase());
        if (!user.getLoginName().matches("^\\w([\\w\\-]){0,254}")) {
            throw new CommonException("\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002", "invaild_format", new Object[]{"\u8d26\u53f7", "\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002"});
        }
        if (user.getLoginName().length() > 255) {
            throw new CommonException("\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u8d26\u53f7", "255"});
        }
        if (StringUtils.isNotBlank((String)user.getEmail())) {
            user.setEmail(user.getEmail().toLowerCase());
        }
        UserExample userEx1 = new UserExample();
        userEx1.createCriteria().andLoginNameEqualTo(user.getLoginName());
        if (this.userMapper.countByExample(userEx1) > 0) {
            throw new CommonException("\u76f8\u540c\u7528\u6237\u5df2\u5b58\u5728", "base_the_same_account");
        }
        if (StringUtils.isNotBlank((String)user.getMobilePhone())) {
            if (user.getMobilePhone().length() > 11) {
                throw new CommonException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7528\u6237\u624b\u673a\u53f7", 11});
            }
            UserExample mobilePhoneExample = new UserExample();
            mobilePhoneExample.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone());
            if (this.userMapper.countByExample(mobilePhoneExample) > 0) {
                throw new CommonException("\u624b\u673a\u53f7\u5df2\u5b58\u5728", "base_the_same_mobile");
            }
        }
        if (StringUtils.isNotBlank((String)user.getEmail())) {
            if (user.getEmail().length() > 255) {
                throw new CommonException("\u7528\u6237\u90ae\u7bb1\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u7528\u6237\u90ae\u7bb1\u53f7", 255});
            }
            UserExample emailExample = new UserExample();
            emailExample.createCriteria().andEmailEqualTo(user.getEmail());
            if (this.userMapper.countByExample(emailExample) > 0) {
                throw new CommonException("Email\u5df2\u5b58\u5728", "base_the_same_email");
            }
        }
        String passwordKey = StringUtils.leftPad((String)String.valueOf(RandomUtils.nextInt((int)1000000)), (int)6, (String)"0");
        user.setPasswordKey(passwordKey);
        try {
            String password = DESUtils.encrypt((String)(DESUtils.encrypt((String)user.getPassword(), (String)"tissonco") + passwordKey), (String)"tissonco");
            user.setPassword(password);
            user.setPasswordKey(passwordKey);
            this.userMapper.insertSelective(user);
            if (isPublishEvent == null) {
                isPublishEvent = true;
            }
            if (isPublishEvent.booleanValue()) {
                SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new UserCreatedEvent(user));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    @Transactional
    public void addUserFromMdm(User user) {
        Assert.isNotBlank((String)user.getLoginName(), (String)"\u767b\u5f55\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        user.setLoginName(user.getLoginName().toLowerCase());
        if (!user.getLoginName().matches("^\\w([\\w\\-]){4,254}")) {
            throw new CommonException("\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002", "invaild_format", new Object[]{"\u8d26\u53f7", "\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002"});
        }
        if (user.getLoginName().length() > 255) {
            throw new CommonException("\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u8d26\u53f7", "255"});
        }
        UserExample userEx1 = new UserExample();
        userEx1.createCriteria().andLoginNameEqualTo(user.getLoginName());
        if (this.userMapper.countByExample(userEx1) > 0) {
            throw new CommonException("\u76f8\u540c\u7528\u6237\u5df2\u5b58\u5728", "base_the_same_account");
        }
        String passwordKey = StringUtils.leftPad((String)String.valueOf(RandomUtils.nextInt((int)1000000)), (int)6, (String)"0");
        user.setPasswordKey(passwordKey);
        try {
            String password = DESUtils.encrypt((String)(DESUtils.encrypt((String)"123456", (String)"tissonco") + passwordKey), (String)"tissonco");
            user.setPassword(password);
            user.setPasswordKey(passwordKey);
            this.userMapper.insertSelective(user);
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new UserCreatedEvent(user));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public List<User> queryAllObjByExample(UserExample example) {
        return this.userMapper.selectByExample(example);
    }

    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public PageView<User> queryObjByPage(UserExample example) {
        PageView<User> pageView = example.getPageView();
        pageView.setQueryResult(this.userMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public boolean findUserIsExist(User user) {
        if (StringUtils.isBlank((String)user.getLoginName()) && StringUtils.isBlank((String)user.getMobilePhone()) && StringUtils.isBlank((String)user.getMobilePhone())) {
            throw new CommonException("\u53c2\u6570\u5f02\u5e38\uff0c\u65e0\u6cd5\u67e5\u51fa\u662f\u5426\u5b58\u5728\u91cd\u590d\u7528\u6237", "base_param_error", new Object[]{"\u65e0\u6cd5\u67e5\u51fa\u662f\u5426\u5b58\u5728\u91cd\u590d\u7528\u6237"});
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone());
        userExample.or().andEmailEqualTo(user.getEmail().toLowerCase());
        userExample.or().andLoginNameEqualTo(user.getLoginName().toLowerCase());
        return this.userMapper.countByExample(userExample) > 0;
    }

    @CacheEvict(value={"userService"}, allEntries=true)
    public void deleteByExample(UserExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.userMapper.deleteByExample(example);
    }

    @CacheEvict(value={"userService"}, allEntries=true)
    @Transactional
    public void addAll(List<User> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.userMapper.insertSelective((User)record));
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public Optional<User> queryByMobilePhone(String mobilePhone) {
        UserExample example = new UserExample();
        example.or().andMobilePhoneEqualTo(mobilePhone);
        List<User> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    @Override
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public Optional<User> queryByEmail(String email) {
        UserExample example = new UserExample();
        example.or().andEmailEqualTo(email);
        List<User> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    @Override
    @Transactional
    @Cacheable(value={"userService"}, keyGenerator="redisKeyGenerator")
    public void submitAuth(User authInfo) {
        authInfo.setId(null);
        authInfo.setCreateTime(new Date());
        authInfo.setAuthStatus(0);
        authInfo.setIsEnable(1);
        authInfo.setProjectCode(ProjectUtils.getProject().getProjectCode());
        this.addObj(authInfo);
        this.userListeners.ifPresent(listeners -> listeners.stream().forEach(listener -> listener.onSubmitAuth(authInfo)));
    }

    @Override
    @Transactional
    @CacheEvict(value={"userService"}, allEntries=true)
    public void authPass(String id) {
        User user = this.queryObjById(id);
        Assert.isNotNull((Object)user, (String)("\u4e0d\u5b58\u5728id\u4e3a " + id + " \u7684\u7528\u6237"));
        this.update(user, u -> {
            u.setAuthTime(new Date());
            u.setAuthStatus(1);
        });
        this.userListeners.ifPresent(listeners -> listeners.stream().forEach(listener -> listener.onAuthPass(user)));
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void modifyAvatar(String userId, String avatar) {
        User updateVO = new User();
        updateVO.setUserImg(avatar);
        UserExample example = new UserExample();
        example.or().andIdEqualTo(userId);
        this.userMapper.updateByExampleSelective(updateVO, example);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public User update(User user, Consumer<User> setter) {
        if (user == null || setter == null) {
            return user;
        }
        User updateVO = new User();
        updateVO.setId(user.getId());
        setter.accept(updateVO);
        setter.accept(user);
        this.updateByPrimaryKeySelective(updateVO);
        return user;
    }

    @Override
    public User validateNickNameAndEmail(String nickName, String email) {
        UserExample example = new UserExample();
        example.or().andNickNameEqualTo(nickName).andEmailEqualTo(email).andIsEnableEqualTo(Constant.YES_INT);
        List<User> list = this.userMapper.selectByExampleByPage(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u6635\u79f0\u4e0e\u90ae\u7bb1\u4e0d\u5339\u914d");
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"userService"}, allEntries=true)
    public void setAsManager(String userId, String managerId) {
        User user = this.queryObjById(userId);
        Assert.isNotNull((Object)user, (String)("\u4e0d\u5b58\u5728id\u4e3a " + userId + " \u7684\u7528\u6237"));
        User manager = this.queryObjById(managerId);
        Assert.isNotNull((Object)manager, (String)("\u4e0d\u5b58\u5728id\u4e3a " + managerId + " \u7684\u7528\u6237"));
        User updateUser = new User();
        updateUser.setId(userId);
        updateUser.setManagerId(managerId);
        updateUser.setManagerName(manager.getNickName());
        this.userMapper.updateByPrimaryKeySelective(updateUser);
    }
}

