/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.controller.dictionary;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5b57\u5178\u7ec4\u5b50\u9879"})
@Controller
@RequestMapping(value={"dicGroupItem"})
public class DicGroupItemController {
    @Resource
    protected DicGroupItemService dicGroupItemService;
    @Resource
    protected DicGroupService dicGroupService;

    @ApiIgnore
    @RequestMapping(value={"service/toAddView"})
    public ModelAndView toAddView(String dicGroupId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("base/dictionary/dicGroupItem/toAddView");
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupId);
        view.addObject("dicGroup", (Object)dicGroup);
        return view;
    }

    @ApiIgnore
    @RequestMapping(value={"service/toUpdateViewById"})
    public ModelAndView toDicGroupById(String id) {
        ModelAndView view = new ModelAndView();
        DicGroupItem dicGroupItem = null;
        dicGroupItem = this.dicGroupItemService.queryObjById(id);
        view.addObject("dicGroupItem", (Object)dicGroupItem);
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupItem.getGroupId());
        view.addObject("dicGroup", (Object)dicGroup);
        view.setViewName("base/dictionary/dicGroupItem/toAddView");
        return view;
    }

    @ApiIgnore
    @RequestMapping(value={"service/toListPageView"})
    public ModelAndView toListPageView(String dicGroupId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("base/dictionary/dicGroupItem/listPageView");
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupId);
        view.addObject("dicGroup", (Object)dicGroup);
        return view;
    }

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u7ec4\u5b50\u9879", httpMethod="POST")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DicGroupItem dicGroupItem) {
        this.dicGroupItemService.addObj(dicGroupItem);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u7f16\u8f91\u5b57\u5178\u7ec4\u5b50\u9879", httpMethod="POST")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DicGroupItem dicGroupItem) {
        this.dicGroupItemService.modifyObj(dicGroupItem);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u7ec4\u5b50\u9879", httpMethod="POST")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.dicGroupItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b57\u5178\u7ec4\u5b50\u9879", httpMethod="GET")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DicGroupItem>> findByPage(@ApiParam(value="\u5206\u7ec4id") String dicGroupId, @ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        DicGroupItemExample example = new DicGroupItemExample();
        example.setPageView((PageView<DicGroupItem>)new PageView(pageNo, pageSize));
        DicGroupItemExample.Criteria cri1 = example.createCriteria();
        cri1.andGroupIdEqualTo(dicGroupId);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)cri1, queryParams);
        }
        PageView<DicGroupItem> pageView = this.dicGroupItemService.queryObjByPage(example);
        return ResponseResult.success(pageView);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7ec4\u7684code\u503c\uff0c\u67e5\u8be2\u6240\u6709\u5b50\u9879", httpMethod="GET")
    @RequestMapping(value={"service/findByDicGroupCode", "front/findByDicGroupCode"})
    @ResponseBody
    public ResponseResult<List<DicGroupItem>> findByDicGroupCode(String dicGroupCode) {
        List<DicGroupItem> list = this.dicGroupItemService.queryItemsByGroupCode(dicGroupCode);
        return ResponseResult.success(list);
    }
}

