/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.option.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.option.entity.Option;
import com.els.base.option.entity.OptionExample;
import com.els.base.option.service.OptionService;
import com.els.base.option.validate.OptionAddView;
import com.els.base.option.validate.OptionUpdateView;
import com.els.base.option.validate.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002"})
@Controller
@RequestMapping(value={"option"})
public class OptionController {
    @Resource
    protected OptionService optionService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@Validated(value={OptionAddView.class}) @RequestBody Option option, BindingResult bindingResult) {
        ValidateUtils.validate(bindingResult);
        OptionExample example = new OptionExample();
        example.createCriteria().andCodeEqualTo(option.getCode());
        int i = this.optionService.countByExample(example);
        if (i > 0) {
            throw new CommonException(option.getCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        option.setCreateTime(new Date());
        this.optionService.addObj(option);
        return ResponseResult.success((Object)option.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@Validated(value={OptionUpdateView.class}) @RequestBody Option option, BindingResult bindingResult) {
        ValidateUtils.validate(bindingResult);
        OptionExample example = new OptionExample();
        example.createCriteria().andCodeEqualTo(option.getCode()).andIdNotEqualTo(option.getId());
        int i = this.optionService.countByExample(example);
        if (i > 0) {
            throw new CommonException(option.getCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        option.setUpdateTime(new Date());
        this.optionService.modifyObj(option);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OptionExample example = new OptionExample();
        example.createCriteria().andIdIn((List)ids);
        this.optionService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u8be2\u914d\u7f6e\u4fe1\u606f\u3002")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<Option> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\uff01");
        Option option = (Option)this.optionService.queryObjById(id);
        return ResponseResult.success((Object)option);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002")
    @RequestMapping(value={"front/findByKeys"})
    @ResponseBody
    public ResponseResult<List<Option>> findByKeys(@RequestBody(required=true) List<String> keys) {
        Assert.isNotEmpty(keys, (String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2akey\u503c!");
        OptionExample example = new OptionExample();
        example.createCriteria().andCodeIn((List)keys);
        List<Option> options = this.optionService.selectByExampleWithBLOBs(example);
        return ResponseResult.success(options);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u914d\u7f6e\u4fe1\u606f\u8868\uff0c\u7528\u6765\u4fdd\u5b58\u7f51\u7ad9\u7684\u6240\u6709\u914d\u7f6e\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Option", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Option>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OptionExample example = new OptionExample();
        example.setPageView((PageView<Option>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        OptionExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<Option> pageData = this.optionService.queryObjWithBLOBsByPage(example);
        return ResponseResult.success(pageData);
    }
}

