package com.els.base.core.web.controller.project;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="项目")
@Controller
@RequestMapping("project")
public class ProjectController {
    @Resource
    protected ProjectService projectService;

    @ApiOperation(httpMethod="POST", value="创建项目")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Project project) {
        this.projectService.addObj(project);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑项目")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Project project) {
    	Assert.isNotBlank(project.getId(), "id 为空，保存失败", "material_id_is_not_null");
    	
        this.projectService.modifyObj(project);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除项目")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.projectService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查询项目")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Project>> findByPage(
    		@ApiParam(value="分页索引",defaultValue="1") @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(value="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件") String sSearch) {
        ProjectExample example = new ProjectExample();
        example.setPageView(new PageView<Project>(pageNo, pageSize));
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        PageView<Project> pageData = this.projectService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}